/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class DebouncedRunnable {
    private final Runnable runnable;
    private final long debounceTimeNanos;
    private ScheduledFuture<?> scheduledTask;

    public DebouncedRunnable(Runnable runnable, Duration duration) {
        this.runnable = runnable;
        this.debounceTimeNanos = duration.toNanos();
    }

    private DebouncedRunnable(Runnable runnable, long l, ScheduledFuture<?> scheduledFuture) {
        this.runnable = runnable;
        this.debounceTimeNanos = l;
        this.scheduledTask = scheduledFuture;
    }

    public void run(ScheduledExecutorService scheduledExecutorService) {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
        this.scheduledTask = scheduledExecutorService.schedule(this.runnable, this.debounceTimeNanos, TimeUnit.NANOSECONDS);
    }

    public DebouncedRunnable andThen(Runnable runnable) {
        Runnable runnable2 = () -> {
            this.runnable.run();
            runnable.run();
        };
        return new DebouncedRunnable(runnable2, this.debounceTimeNanos, this.scheduledTask);
    }
}

