/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Function;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.CheckedFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.FileConfigBuilder;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.FormatDetector;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.NoFormatFoundException;

public interface FileConfig
extends Config,
AutoCloseable {
    public File getFile();

    public Path getNioPath();

    public void save();

    public void load();

    @Override
    public void close();

    @Override
    default public FileConfig checked() {
        return new CheckedFileConfig(this);
    }

    public <R> R bulkUpdate(Function<? super Config, R> var1);

    default public void bulkUpdate(Consumer<? super Config> consumer) {
        this.bulkUpdate((? super Config config) -> {
            consumer.accept((Config)config);
            return null;
        });
    }

    public static FileConfig of(File file) {
        return FileConfig.of(file.toPath());
    }

    public static FileConfig of(File file, ConfigFormat<? extends Config> configFormat) {
        return FileConfig.of(file.toPath(), configFormat);
    }

    public static FileConfig of(Path path) {
        ConfigFormat<?> configFormat = FormatDetector.detect(path);
        if (configFormat == null) {
            throw new NoFormatFoundException("No suitable format for " + String.valueOf(path.getFileName()));
        }
        return FileConfig.of(path, configFormat);
    }

    public static FileConfig of(Path path, ConfigFormat<? extends Config> configFormat) {
        return FileConfig.builder(path, configFormat).build();
    }

    public static FileConfig of(String string) {
        return FileConfig.of(Paths.get(string, new String[0]));
    }

    public static FileConfig of(String string, ConfigFormat<?> configFormat) {
        return FileConfig.of(Paths.get(string, new String[0]), configFormat);
    }

    @Deprecated
    public static FileConfig ofConcurrent(File file) {
        return FileConfig.ofConcurrent(file.toPath());
    }

    @Deprecated
    public static FileConfig ofConcurrent(File file, ConfigFormat<?> configFormat) {
        return FileConfig.ofConcurrent(file.toPath(), configFormat);
    }

    @Deprecated
    public static FileConfig ofConcurrent(Path path) {
        return FileConfig.builder(path).concurrent().build();
    }

    @Deprecated
    public static FileConfig ofConcurrent(Path path, ConfigFormat<?> configFormat) {
        return FileConfig.builder(path, configFormat).concurrent().build();
    }

    @Deprecated
    public static FileConfig ofConcurrent(String string) {
        return FileConfig.ofConcurrent(Paths.get(string, new String[0]));
    }

    @Deprecated
    public static FileConfig ofConcurrent(String string, ConfigFormat<?> configFormat) {
        return FileConfig.ofConcurrent(Paths.get(string, new String[0]), configFormat);
    }

    public static FileConfigBuilder builder(File file) {
        return FileConfig.builder(file.toPath());
    }

    public static FileConfigBuilder builder(File file, ConfigFormat<?> configFormat) {
        return FileConfig.builder(file.toPath(), configFormat);
    }

    public static FileConfigBuilder builder(Path path) {
        ConfigFormat<?> configFormat = FormatDetector.detect(path);
        if (configFormat == null) {
            throw new NoFormatFoundException("No suitable format for " + String.valueOf(path.getFileName()));
        }
        return FileConfig.builder(path, configFormat);
    }

    public static FileConfigBuilder builder(Path path, ConfigFormat<?> configFormat) {
        return new FileConfigBuilder(path, (ConfigFormat<? extends Config>)configFormat);
    }

    public static FileConfigBuilder builder(String string) {
        return FileConfig.builder(Paths.get(string, new String[0]));
    }

    public static FileConfigBuilder builder(String string, ConfigFormat<?> configFormat) {
        return FileConfig.builder(Paths.get(string, new String[0]), configFormat);
    }
}

