/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.StringUtils;

public final class FormatDetector {
    private static final Map<String, Supplier<ConfigFormat<?>>> registry = new ConcurrentHashMap();

    public static void registerExtension(String string, ConfigFormat<?> configFormat) {
        registry.put(string, () -> configFormat);
    }

    public static void registerExtension(String string, Supplier<ConfigFormat<?>> supplier) {
        registry.put(string, supplier);
    }

    public static ConfigFormat<?> detect(File file) {
        return FormatDetector.detectByName(file.getName());
    }

    public static ConfigFormat<?> detect(Path path) {
        return FormatDetector.detectByName(path.getFileName().toString());
    }

    public static ConfigFormat<?> detectByName(String string) {
        List<String> list = StringUtils.split(string, '.');
        String string2 = list.get(list.size() - 1);
        Supplier<ConfigFormat<?>> supplier = registry.get(string2);
        return supplier == null ? null : supplier.get();
    }

    private static void tryLoad(String string) {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private FormatDetector() {
    }

    static {
        FormatDetector.tryLoad("me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.TomlFormat");
        FormatDetector.tryLoad("me.roundaround.enchantmentcompat.roundalib.nightconfig.hocon.HoconFormat");
        FormatDetector.tryLoad("me.roundaround.enchantmentcompat.roundalib.nightconfig.json.JsonFormat");
        FormatDetector.tryLoad("me.roundaround.enchantmentcompat.roundalib.nightconfig.yaml.YamlFormat");
    }
}

