/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.concurrent.StampedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.concurrent.SynchronizedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.AsyncFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.AutoreloadFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.AutosaveCommentedFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.CommentedFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.ConfigLoadFilter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.FileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.FileNotFoundAction;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.FileWatcher;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.SyncFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.ConfigParser;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.ConfigWriter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.ParsingMode;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.WritingException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.WritingMode;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.CommentedConfigWrapper;

public abstract class GenericBuilder<Base extends Config, Result extends FileConfig> {
    protected final Path file;
    protected final ConfigFormat<? extends Base> format;
    protected final ConfigWriter writer;
    protected final ConfigParser<? extends Base> parser;
    protected Charset charset = StandardCharsets.UTF_8;
    protected WritingMode writingMode = WritingMode.REPLACE;
    protected ParsingMode parsingMode = ParsingMode.REPLACE;
    protected FileNotFoundAction nefAction = FileNotFoundAction.CREATE_EMPTY;
    protected boolean sync = false;
    protected boolean autosave = false;
    protected boolean atomicMove = false;
    protected FileWatcher autoreloadFileWatcher = null;
    protected boolean preserveInsertionOrder = Config.isInsertionOrderPreserved();
    protected Supplier<Map<String, Object>> mapCreator = null;
    private ConfigLoadFilter loadFilter;
    protected Runnable loadListener;
    protected Runnable saveListener;
    protected Runnable autoLoadListener;
    protected Runnable autoSaveListener;
    private Duration debounceTime = AsyncFileConfig.DEFAULT_WRITE_DEBOUNCE_TIME;

    GenericBuilder(Path path, ConfigFormat<? extends Base> configFormat) {
        this.file = path;
        this.format = configFormat;
        this.writer = configFormat.createWriter();
        this.parser = configFormat.createParser();
    }

    public GenericBuilder<Base, Result> charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public GenericBuilder<Base, Result> writingMode(WritingMode writingMode) {
        this.writingMode = writingMode;
        return this;
    }

    public GenericBuilder<Base, Result> parsingMode(ParsingMode parsingMode) {
        this.parsingMode = parsingMode;
        return this;
    }

    public GenericBuilder<Base, Result> onFileNotFound(FileNotFoundAction fileNotFoundAction) {
        this.nefAction = fileNotFoundAction;
        return this;
    }

    public GenericBuilder<Base, Result> defaultResource(String string) {
        return this.onFileNotFound(FileNotFoundAction.copyResource(string));
    }

    public GenericBuilder<Base, Result> defaultData(File file) {
        return this.onFileNotFound(FileNotFoundAction.copyData(file));
    }

    public GenericBuilder<Base, Result> defaultData(Path path) {
        return this.onFileNotFound(FileNotFoundAction.copyData(path));
    }

    public GenericBuilder<Base, Result> defaultData(URL uRL) {
        return this.onFileNotFound(FileNotFoundAction.copyData(uRL));
    }

    public GenericBuilder<Base, Result> sync() {
        this.sync = true;
        return this;
    }

    public GenericBuilder<Base, Result> async() {
        this.sync = false;
        return this;
    }

    public GenericBuilder<Base, Result> asyncWithDebouncing(Duration duration) {
        this.sync = false;
        this.debounceTime = duration;
        return this;
    }

    public GenericBuilder<Base, Result> autosave() {
        this.autosave = true;
        return this;
    }

    public GenericBuilder<Base, Result> autoreload() {
        return this.autoreload(FileWatcher.defaultInstance());
    }

    public GenericBuilder<Base, Result> autoreload(FileWatcher fileWatcher) {
        this.autoreloadFileWatcher = fileWatcher;
        return this;
    }

    public GenericBuilder<Base, Result> onAutoReload(Runnable runnable) {
        this.autoLoadListener = runnable;
        return this;
    }

    public GenericBuilder<Base, Result> onAutoSave(Runnable runnable) {
        this.autoSaveListener = runnable;
        return this;
    }

    public GenericBuilder<Base, Result> onLoad(Runnable runnable) {
        this.loadListener = runnable;
        return this;
    }

    public GenericBuilder<Base, Result> onSave(Runnable runnable) {
        this.saveListener = runnable;
        return this;
    }

    public GenericBuilder<Base, Result> onLoadFilter(ConfigLoadFilter configLoadFilter) {
        this.loadFilter = configLoadFilter;
        return this;
    }

    @Deprecated
    public GenericBuilder<Base, Result> concurrent() {
        return this;
    }

    public GenericBuilder<Base, Result> preserveInsertionOrder() {
        this.preserveInsertionOrder = true;
        return this;
    }

    public GenericBuilder<Base, Result> backingMapCreator(Supplier<Map<String, Object>> supplier) {
        this.mapCreator = supplier;
        return this;
    }

    private Runnable runnableOrNothing(Runnable runnable) {
        return runnable == null ? () -> {} : runnable;
    }

    public Result build() {
        CommentedConfigWrapper commentedConfigWrapper;
        if (this.mapCreator == null) {
            this.mapCreator = this.preserveInsertionOrder ? LinkedHashMap::new : HashMap::new;
        }
        this.saveListener = this.runnableOrNothing(this.saveListener);
        this.loadListener = this.runnableOrNothing(this.loadListener);
        this.autoSaveListener = this.runnableOrNothing(this.autoSaveListener);
        this.autoLoadListener = this.runnableOrNothing(this.autoLoadListener);
        if (this.autoreloadFileWatcher != null && Files.notExists(this.file, new LinkOption[0])) {
            try {
                this.nefAction.run(this.file, this.format);
            }
            catch (IOException iOException) {
                String string = "An exception occured while executing the FileNotFoundAction for file: " + String.valueOf(this.file);
                throw new WritingException(string, iOException);
            }
        }
        if (this.sync) {
            SynchronizedConfig synchronizedConfig = new SynchronizedConfig(this.format, this.mapCreator);
            commentedConfigWrapper = new SyncFileConfig(synchronizedConfig, this.file, this.charset, this.writer, this.writingMode, this.parser, this.parsingMode, this.nefAction, this.loadFilter, this.saveListener, this.loadListener);
        } else {
            StampedConfig stampedConfig = new StampedConfig(this.format, this.mapCreator);
            commentedConfigWrapper = new AsyncFileConfig(stampedConfig, this.file, this.charset, this.writer, this.writingMode, this.parser, this.parsingMode, this.nefAction, false, this.loadFilter, this.saveListener, this.loadListener, this.debounceTime);
        }
        if (this.autoreloadFileWatcher != null) {
            commentedConfigWrapper = new AutoreloadFileConfig<SyncFileConfig>((SyncFileConfig)commentedConfigWrapper, this.autoreloadFileWatcher, this.autoLoadListener);
        }
        if (this.autosave) {
            return this.buildAutosave((CommentedFileConfig)((Object)commentedConfigWrapper));
        }
        return this.buildNormal((CommentedFileConfig)((Object)commentedConfigWrapper));
    }

    protected Result buildAutosave(CommentedFileConfig commentedFileConfig) {
        return (Result)new AutosaveCommentedFileConfig(commentedFileConfig, this.autoSaveListener);
    }

    protected Result buildNormal(CommentedFileConfig commentedFileConfig) {
        return (Result)commentedFileConfig;
    }
}

