/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io;

import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.AbstractInput;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.ParsingException;

public final class ArrayInput
extends AbstractInput {
    private final char[] chars;
    private final int limit;
    private int cursor;

    public ArrayInput(CharsWrapper charsWrapper) {
        this(charsWrapper.chars, charsWrapper.offset, charsWrapper.limit);
    }

    public ArrayInput(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public ArrayInput(char[] cArray, int n, int n2) {
        this.chars = cArray;
        this.cursor = n;
        this.limit = n2;
    }

    @Override
    protected int directRead() {
        if (this.cursor >= this.limit) {
            return -1;
        }
        return this.chars[this.cursor++];
    }

    @Override
    protected char directReadChar() throws ParsingException {
        if (this.cursor >= this.limit) {
            throw ParsingException.notEnoughData();
        }
        return this.chars[this.cursor++];
    }

    @Override
    public CharsWrapper read(int n) {
        int n2;
        int n3 = Math.min(n, this.limit - this.cursor + this.deque.size());
        char[] cArray = new char[n3];
        CharsWrapper charsWrapper = this.consumeDeque(cArray, n2 = Math.min(this.deque.size(), n3), false);
        if (charsWrapper != null) {
            return charsWrapper;
        }
        System.arraycopy(this.chars, this.cursor, cArray, n2, n3 - n2);
        this.cursor += n3;
        return new CharsWrapper(cArray);
    }

    @Override
    public CharsWrapper readChars(int n) {
        if (this.limit - this.cursor + this.deque.size() < n) {
            throw ParsingException.notEnoughData();
        }
        int n2 = Math.min(this.deque.size(), n);
        char[] cArray = new char[n];
        this.consumeDeque(cArray, n2, true);
        System.arraycopy(this.chars, this.cursor, cArray, n2, n - n2);
        this.cursor += n;
        return new CharsWrapper(cArray);
    }
}

