/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Optional;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.DeserializerContext;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.SerdeException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.TypeConstraint;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.ValueDeserializer;

final class ConfigToPojoDeserializer
implements ValueDeserializer<UnmodifiableConfig, Object> {
    ConfigToPojoDeserializer() {
    }

    @Override
    public Object deserialize(UnmodifiableConfig unmodifiableConfig, Optional<TypeConstraint> optional, DeserializerContext deserializerContext) {
        Object obj;
        if (!optional.isPresent()) {
            return unmodifiableConfig;
        }
        TypeConstraint typeConstraint = optional.get();
        Class<?> clazz = typeConstraint.getSatisfyingRawType().orElseThrow(() -> new SerdeException("Could not find a concrete type that can satisfy the constraint " + String.valueOf(typeConstraint)));
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            obj = constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new SerdeException("Failed to create an instance of " + String.valueOf(clazz), exception);
        }
        deserializerContext.deserializeFields(unmodifiableConfig, obj);
        return obj;
    }
}

