/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.ConfigToPojoDeserializer;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.ObjectDeserializer;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.StandardDeserializers;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.TypeConstraint;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.Util;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.ValueDeserializer;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.ValueDeserializerProvider;

public final class ObjectDeserializerBuilder {
    final List<ValueDeserializerProvider<?, ?>> deserializerProviders = new ArrayList();
    ValueDeserializerProvider<?, ?> defaultProvider = NoProvider.INSTANCE;
    boolean applyTransientModifier = true;

    ObjectDeserializerBuilder(boolean bl) {
        if (bl) {
            this.registerStandardDeserializers();
        }
    }

    public ObjectDeserializer build() {
        return new ObjectDeserializer(this);
    }

    public void deserializeTransientFields() {
        this.applyTransientModifier = false;
    }

    public <V, R> void withDeserializerForClass(Class<V> clazz, Class<R> clazz2, ValueDeserializer<? super V, ? extends R> valueDeserializer) {
        this.withDeserializerProvider((clazz3, typeConstraint) -> typeConstraint.getSatisfyingRawType().map(clazz4 -> {
            if (clazz3.isAssignableFrom(clazz) && clazz4.isAssignableFrom(clazz2)) {
                return valueDeserializer;
            }
            return null;
        }).orElse(null));
    }

    public <V, R> void withDeserializerProvider(ValueDeserializerProvider<V, R> valueDeserializerProvider) {
        this.deserializerProviders.add(valueDeserializerProvider);
    }

    public <V, R> void withDefaultDeserializerProvider(ValueDeserializerProvider<V, R> valueDeserializerProvider) {
        this.defaultProvider = valueDeserializerProvider;
    }

    public void withDefaultDeserializerProvider() {
        ConfigToPojoDeserializer configToPojoDeserializer = new ConfigToPojoDeserializer();
        this.defaultProvider = (clazz, typeConstraint) -> {
            if (UnmodifiableConfig.class.isAssignableFrom(clazz)) {
                return configToPojoDeserializer;
            }
            return null;
        };
    }

    private void registerStandardDeserializers() {
        this.withDefaultDeserializerProvider();
        StandardDeserializers.TrivialDeserializer trivialDeserializer = new StandardDeserializers.TrivialDeserializer();
        StandardDeserializers.MapDeserializer mapDeserializer = new StandardDeserializers.MapDeserializer();
        StandardDeserializers.CollectionDeserializer collectionDeserializer = new StandardDeserializers.CollectionDeserializer();
        StandardDeserializers.CollectionToArrayDeserializer collectionToArrayDeserializer = new StandardDeserializers.CollectionToArrayDeserializer();
        StandardDeserializers.EnumDeserializer enumDeserializer = new StandardDeserializers.EnumDeserializer();
        StandardDeserializers.UuidDeserializer uuidDeserializer = new StandardDeserializers.UuidDeserializer();
        StandardDeserializers.RiskyNumberDeserializer riskyNumberDeserializer = new StandardDeserializers.RiskyNumberDeserializer();
        this.withDeserializerProvider((clazz, typeConstraint) -> {
            Type type = typeConstraint.getFullType();
            return typeConstraint.getSatisfyingRawType().map(clazz2 -> {
                if (Util.canAssign(clazz2, clazz) && (clazz == null || type instanceof Class)) {
                    return trivialDeserializer;
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    if (Collection.class.isAssignableFrom((Class<?>)clazz2)) {
                        return collectionDeserializer;
                    }
                    if (clazz2.isArray()) {
                        return collectionToArrayDeserializer;
                    }
                }
                if ((UnmodifiableConfig.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) && Map.class.isAssignableFrom((Class<?>)clazz2)) {
                    return mapDeserializer;
                }
                if (clazz2 == UUID.class && clazz == String.class) {
                    return uuidDeserializer;
                }
                if (clazz == String.class && Enum.class.isAssignableFrom((Class<?>)clazz2)) {
                    return enumDeserializer;
                }
                if (StandardDeserializers.RiskyNumberDeserializer.isNumberTypeSupported(clazz) && Util.isPrimitiveOrWrapperNumber(clazz2)) {
                    return riskyNumberDeserializer;
                }
                return null;
            }).orElse(null);
        });
    }

    static final class NoProvider
    implements ValueDeserializerProvider<Object, Object> {
        static final NoProvider INSTANCE = new NoProvider();

        NoProvider() {
        }

        @Override
        public ValueDeserializer<Object, Object> provide(Class<?> clazz, TypeConstraint typeConstraint) {
            return null;
        }
    }
}

