/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.EnumGetMethod;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.DeserializerContext;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.SerdeException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.TypeConstraint;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde.ValueDeserializer;

final class StandardDeserializers {
    private StandardDeserializers() {
    }

    static final class RiskyNumberDeserializer
    implements ValueDeserializer<Number, Number> {
        RiskyNumberDeserializer() {
        }

        public static boolean isNumberTypeSupported(Class<?> clazz) {
            return clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Number deserialize(Number number, Optional<TypeConstraint> optional, DeserializerContext deserializerContext) {
            TypeConstraint typeConstraint = optional.orElseThrow(() -> new SerdeException("Cannot deserialize a value with a risky number conversion without knowing the number type"));
            Class<?> clazz = typeConstraint.getSatisfyingRawType().orElseThrow(() -> new SerdeException("Could not find a concrete number type that can satisfy the constraint " + String.valueOf(typeConstraint)));
            Class<?> clazz2 = number.getClass();
            if (clazz2 == Long.class) {
                long l = number.longValue();
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    int n = (int)l;
                    if ((long)n != l) throw new SerdeException(String.format("Cannot deserialize %s to %s: the conversion would be lossy", number, clazz));
                    return n;
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    short s = (short)l;
                    if ((long)s != l) throw new SerdeException(String.format("Cannot deserialize %s to %s: the conversion would be lossy", number, clazz));
                    return s;
                }
                if (clazz != Byte.class && clazz != Byte.TYPE) throw new SerdeException(String.format("Cannot deserialize from %s to %s: risky conversion not implemented, you should change your types.", clazz2, clazz));
                byte by = (byte)l;
                if ((long)by != l) throw new SerdeException(String.format("Cannot deserialize %s to %s: the conversion would be lossy", number, clazz));
                return by;
            }
            if (clazz2 != Integer.class) throw new SerdeException(String.format("Cannot deserialize %s to %s: the conversion would be lossy", number, clazz));
            int n = number.intValue();
            if (clazz == Short.class || clazz == Short.TYPE) {
                short s = (short)n;
                if (s != n) throw new SerdeException(String.format("Cannot deserialize %s to %s: the conversion would be lossy", number, clazz));
                return s;
            }
            if (clazz != Byte.class && clazz != Byte.TYPE) throw new SerdeException(String.format("Cannot deserialize from %s to %s: risky conversion not implemented, you should change your types.", clazz2, clazz));
            byte by = (byte)n;
            if (by != n) throw new SerdeException(String.format("Cannot deserialize %s to %s: the conversion would be lossy", number, clazz));
            return by;
        }
    }

    static final class UuidDeserializer
    implements ValueDeserializer<String, UUID> {
        UuidDeserializer() {
        }

        @Override
        public UUID deserialize(String string, Optional<TypeConstraint> optional, DeserializerContext deserializerContext) {
            return UUID.fromString(string);
        }
    }

    static final class EnumDeserializer
    implements ValueDeserializer<String, Enum<?>> {
        EnumDeserializer() {
        }

        @Override
        public Enum<?> deserialize(String string, Optional<TypeConstraint> optional, DeserializerContext deserializerContext) {
            TypeConstraint typeConstraint = optional.orElseThrow(() -> new SerdeException("Cannot deserialize a value to an enum without knowing the enum type"));
            Class<?> clazz = typeConstraint.getSatisfyingRawType().orElseThrow(() -> new SerdeException("Could not find a concrete enum type that can satisfy the constraint " + String.valueOf(typeConstraint)));
            return EnumGetMethod.NAME.get(string, clazz);
        }
    }

    static final class CollectionToArrayDeserializer
    implements ValueDeserializer<Collection<?>, Object> {
        CollectionToArrayDeserializer() {
        }

        @Override
        public Object deserialize(Collection<?> collection, Optional<TypeConstraint> optional, DeserializerContext deserializerContext) {
            Optional<TypeConstraint> optional2;
            Object object;
            int n = collection.size();
            if (optional.isPresent()) {
                TypeConstraint typeConstraint = optional.get();
                Class<?> clazz = ((Class)typeConstraint.getFullType()).getComponentType();
                assert (clazz != null);
                object = Array.newInstance(clazz, n);
                optional2 = Optional.of(new TypeConstraint(clazz));
            } else {
                object = new Object[n];
                optional2 = Optional.empty();
            }
            int n2 = 0;
            for (Object e : collection) {
                Object object2 = deserializerContext.deserializeValue(e, optional2);
                Array.set(object, n2, object2);
                ++n2;
            }
            return object;
        }
    }

    static final class CollectionDeserializer
    implements ValueDeserializer<Collection<?>, Collection<?>> {
        CollectionDeserializer() {
        }

        @Override
        public Collection<?> deserialize(Collection<?> collection, Optional<TypeConstraint> optional, DeserializerContext deserializerContext) {
            Optional<TypeConstraint> optional2;
            Collection<Object> collection2;
            int n = collection.size();
            if (optional.isPresent()) {
                TypeConstraint typeConstraint = optional.get();
                collection2 = this.createCollectionInstance(typeConstraint.getSatisfyingRawType().get(), n);
                optional2 = CollectionDeserializer.extractCollectionValueType(typeConstraint);
            } else {
                collection2 = new ArrayList(n);
                optional2 = Optional.empty();
            }
            for (Object e : collection) {
                Object object = deserializerContext.deserializeValue(e, optional2);
                collection2.add(object);
            }
            return collection2;
        }

        private Collection<Object> createCollectionInstance(Class<?> clazz, int n) {
            if (clazz.isAssignableFrom(ArrayList.class)) {
                return new ArrayList<Object>(n);
            }
            if (clazz.isAssignableFrom(LinkedList.class)) {
                return new LinkedList<Object>();
            }
            if (clazz.isAssignableFrom(ArrayDeque.class)) {
                return new ArrayDeque<Object>(n);
            }
            try {
                return (Collection)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new SerdeException("Failed to create an instance of " + String.valueOf(clazz), exception);
            }
        }

        private static Optional<TypeConstraint> extractCollectionValueType(TypeConstraint typeConstraint) {
            return typeConstraint.resolveTypeArgumentsFor(Collection.class).map(typeConstraintArray -> typeConstraintArray[0]);
        }
    }

    static final class MapDeserializer
    implements ValueDeserializer<Object, Map<String, ?>> {
        MapDeserializer() {
        }

        @Override
        public Map<String, ?> deserialize(Object object, Optional<TypeConstraint> optional, DeserializerContext deserializerContext) {
            Optional<Object> optional2;
            Map<Object, Object> map;
            Object object2;
            int n = object instanceof UnmodifiableConfig ? ((UnmodifiableConfig)object).size() : ((Map)object).size();
            if (optional.isPresent()) {
                object2 = optional.get();
                map = MapDeserializer.createMapInstance(((TypeConstraint)object2).getSatisfyingRawType().get(), n);
                optional2 = MapDeserializer.extractMapKVType((TypeConstraint)object2);
            } else {
                optional2 = Optional.empty();
                map = Config.isInsertionOrderPreserved() ? new LinkedHashMap(n) : new HashMap(n);
            }
            object2 = optional2.map(typeConstraintArray -> typeConstraintArray[0]);
            Optional<TypeConstraint> optional3 = optional2.map(typeConstraintArray -> typeConstraintArray[1]);
            if (((Optional)object2).isPresent() && !((TypeConstraint)((Optional)object2).get()).getSatisfyingRawType().equals(Optional.of(String.class))) {
                throw new SerdeException("Invalid map type for deserialization, the keys should be of type String instead of " + String.valueOf(((Optional)object2).get()) + ". Full map type: " + String.valueOf(optional.get()));
            }
            if (object instanceof UnmodifiableConfig) {
                for (UnmodifiableConfig.Entry entry : ((UnmodifiableConfig)object).entrySet()) {
                    String string = entry.getKey();
                    Object t = entry.getValue();
                    Object object3 = deserializerContext.deserializeValue(t, optional3);
                    map.put(string, object3);
                }
            } else {
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    Object object4;
                    Object k = entry.getKey();
                    if (!(k instanceof String)) {
                        object4 = k == null ? "null" : k.getClass().toString();
                        throw new SerdeException("Invalid map type for deserialization, the keys should be of type String instead of " + object4 + ". Full map type: " + String.valueOf(optional.get()));
                    }
                    object4 = entry.getValue();
                    Object object5 = deserializerContext.deserializeValue(object4, optional3);
                    map.put((String)k, object5);
                }
            }
            return map;
        }

        private static Optional<TypeConstraint[]> extractMapKVType(TypeConstraint typeConstraint) {
            return typeConstraint.resolveTypeArgumentsFor(Map.class);
        }

        private static Map<String, Object> createMapInstance(Class<?> clazz, int n) {
            if (clazz == Map.class) {
                return Config.isInsertionOrderPreserved() ? new LinkedHashMap(n) : new HashMap(n);
            }
            if (clazz == LinkedHashMap.class) {
                return new LinkedHashMap<String, Object>(n);
            }
            if (clazz == HashMap.class) {
                return new HashMap<String, Object>(n);
            }
            if (clazz == IdentityHashMap.class) {
                return new IdentityHashMap<String, Object>(n);
            }
            if (clazz.isAssignableFrom(HashMap.class)) {
                if (Config.isInsertionOrderPreserved() && clazz.isAssignableFrom(LinkedHashMap.class)) {
                    return new LinkedHashMap<String, Object>(n);
                }
                return new HashMap<String, Object>(n);
            }
            if (clazz.isAssignableFrom(ConcurrentHashMap.class)) {
                return new ConcurrentHashMap<String, Object>(n);
            }
            try {
                return (Map)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new SerdeException("Failed to create an instance of " + String.valueOf(clazz), exception);
            }
        }
    }

    static final class TrivialDeserializer
    implements ValueDeserializer<Object, Object> {
        TrivialDeserializer() {
        }

        @Override
        public Object deserialize(Object object, Optional<TypeConstraint> optional, DeserializerContext deserializerContext) {
            return object;
        }
    }
}

