/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.serde;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class TypeConstraint {
    private final Type fullType;
    private Optional<Class<?>> rawClass = null;

    static TypeConstraint[] mapArray(Type[] typeArray) {
        TypeConstraint[] typeConstraintArray = new TypeConstraint[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeConstraintArray[i] = new TypeConstraint(typeArray[i]);
        }
        return typeConstraintArray;
    }

    public TypeConstraint(Type type) {
        this.fullType = type;
    }

    public Type getFullType() {
        return this.fullType;
    }

    public Optional<Class<?>> getSatisfyingRawType() {
        if (this.rawClass == null) {
            this.rawClass = Optional.ofNullable(TypeConstraint.findSatisfyingRawType(this.fullType));
        }
        return this.rawClass;
    }

    public Optional<TypeConstraint[]> resolveTypeArgumentsFor(Class<?> clazz) {
        return Optional.ofNullable(TypeConstraint.resolveTypeArgumentsFor(this.fullType, clazz, new HashMap()));
    }

    public String toString() {
        return String.format("TypeConstraint[%s, rawType=%s]", this.fullType, this.getSatisfyingRawType());
    }

    private static final Class<?> findSatisfyingRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeConstraint.findSatisfyingRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            Class<?> clazz = TypeConstraint.findSatisfyingRawType(type2);
            if (clazz == null) {
                return null;
            }
            return Array.newInstance(clazz, 0).getClass();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getLowerBounds();
            Type[] typeArray2 = wildcardType.getUpperBounds();
            if (typeArray2.length == 1) {
                Type type3 = typeArray2[0];
                if (typeArray.length == 1 && type3 == Object.class) {
                    return TypeConstraint.findSatisfyingRawType(typeArray[0]);
                }
                return TypeConstraint.findSatisfyingRawType(type3);
            }
            if (typeArray.length == 1 && typeArray2.length == 0) {
                return TypeConstraint.findSatisfyingRawType(typeArray[0]);
            }
            return null;
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = ((TypeVariable)type).getBounds();
            if (typeArray.length == 1) {
                return TypeConstraint.findSatisfyingRawType(typeArray[0]);
            }
            return null;
        }
        return null;
    }

    private static TypeConstraint[] resolveTypeArgumentsFor(Type type2, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        if (type2 instanceof Class) {
            if (type2 == clazz) {
                return null;
            }
            return TypeConstraint.findParent((Class)type2, type -> TypeConstraint.resolveTypeArgumentsFor(type, clazz, map));
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type type3 = parameterizedType.getRawType();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArray.length; ++i) {
                Type type4 = typeArray[i];
                if (type4 instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)type4;
                    Class clazz2 = (Class)type3;
                    TypeVariable<Class<Object>> typeVariable = clazz2.getTypeParameters()[i];
                    typeArray[i] = TypeConstraint.refineWildcard(wildcardType, typeVariable, map);
                    continue;
                }
                typeArray[i] = TypeConstraint.resolveIfVariable(type4, map);
            }
            if (type3 == clazz) {
                return TypeConstraint.mapArray(typeArray);
            }
            TypeVariable<Class<T>>[] typeVariableArray = ((Class)type3).getTypeParameters();
            for (int i = 0; i < typeVariableArray.length; ++i) {
                map.put(typeVariableArray[i], typeArray[i]);
            }
            return TypeConstraint.findParent((Class)type3, type -> TypeConstraint.resolveTypeArgumentsFor(type, clazz, map));
        }
        if (type2 instanceof TypeVariable) {
            Type[] typeArray = ((TypeVariable)type2).getBounds();
            TypeConstraint[] typeConstraintArray = null;
            for (Type type5 : typeArray) {
                typeConstraintArray = TypeConstraint.resolveTypeArgumentsFor(type5 = TypeConstraint.resolveIfVariable(type5, map), clazz, map);
                if (typeConstraintArray != null) break;
            }
            return typeConstraintArray;
        }
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            TypeConstraint[] typeConstraintArray = null;
            for (Type type6 : wildcardType.getUpperBounds()) {
                typeConstraintArray = TypeConstraint.resolveTypeArgumentsFor(TypeConstraint.resolveIfVariable(type6, map), clazz, map);
                if (typeConstraintArray == null) continue;
                return typeConstraintArray;
            }
            for (Type type6 : wildcardType.getLowerBounds()) {
                typeConstraintArray = TypeConstraint.resolveTypeArgumentsFor(TypeConstraint.resolveIfVariable(type6, map), clazz, map);
                if (typeConstraintArray == null) continue;
                return typeConstraintArray;
            }
        }
        return null;
    }

    private static Type resolveIfVariable(Type type, Map<TypeVariable<?>, Type> map) {
        Type type2;
        if (type instanceof TypeVariable && (type2 = map.get(type)) != null) {
            return type2;
        }
        return type;
    }

    private static <R> R findParent(Class<?> clazz, Function<Type, R> function) {
        R r = null;
        Type type = clazz.getGenericSuperclass();
        if (type != null) {
            r = function.apply(type);
        }
        if (r == null) {
            Type type2;
            Type[] typeArray;
            Type[] typeArray2 = typeArray = clazz.getGenericInterfaces();
            int n = typeArray2.length;
            for (int i = 0; i < n && (r = (R)function.apply(type2 = typeArray2[i])) == null; ++i) {
            }
        }
        return r;
    }

    private static Type wildcardLowerBound(WildcardType wildcardType) {
        Type[] typeArray = wildcardType.getLowerBounds();
        if (typeArray.length > 0) {
            return typeArray[0];
        }
        return null;
    }

    private static Type wildcardUpperBound(WildcardType wildcardType) {
        Type[] typeArray = wildcardType.getUpperBounds();
        if (typeArray.length > 0) {
            return typeArray[0];
        }
        return null;
    }

    static Type refineWildcard(WildcardType wildcardType, TypeVariable<Class<Object>> typeVariable, Map<TypeVariable<?>, Type> map) {
        Type[] typeArray;
        if (wildcardType instanceof RefinedWildcard) {
            return (RefinedWildcard)wildcardType;
        }
        Type type = TypeConstraint.wildcardUpperBound(wildcardType);
        Type[] typeArray2 = wildcardType.getLowerBounds();
        Type[] typeArray3 = typeVariable.getBounds();
        if (typeArray3.length == 0 || typeArray3.length == 1 && (typeArray3[0] == Object.class || typeArray3[0] == type)) {
            return wildcardType;
        }
        Type[] typeArray4 = typeArray2;
        if (type == null || type == Object.class) {
            typeArray = typeArray3;
        } else {
            ArrayList<Type> arrayList = new ArrayList<Type>(typeArray3.length + 1);
            arrayList.add(type);
            for (int i = 0; i < typeArray3.length; ++i) {
                Type type2 = typeArray3[i];
                if (type == type2) continue;
                arrayList.add(type2);
            }
            typeArray = arrayList.toArray(new Type[arrayList.size()]);
        }
        if (typeArray4.length == 1 && typeArray.length == 1 && typeArray4[0].equals(typeArray[0])) {
            return typeArray4[0];
        }
        return new RefinedWildcard(typeArray4, typeArray);
    }

    static final class RefinedWildcard
    implements WildcardType {
        private final Type[] lowerBounds;
        private final Type[] upperBounds;

        RefinedWildcard(Type[] typeArray, Type[] typeArray2) {
            this.lowerBounds = typeArray;
            this.upperBounds = typeArray2;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }

        public String toString() {
            String string = this.lowerBounds.length == 0 ? "" : " >: " + String.valueOf(Arrays.asList(this.lowerBounds));
            String string2 = "<: " + String.valueOf(Arrays.asList(this.upperBounds));
            return "?" + string + " " + string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WildcardType)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            WildcardType wildcardType = (WildcardType)object;
            return Arrays.equals(this.lowerBounds, wildcardType.getLowerBounds()) && Arrays.equals(this.upperBounds, wildcardType.getUpperBounds());
        }

        public int hashCode() {
            return Objects.hash(this.lowerBounds, this.upperBounds);
        }
    }

    static final class ManuallyParameterized
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] arguments;

        public ManuallyParameterized(Type type, Type ... typeArray) {
            this.rawType = Objects.requireNonNull(type);
            this.arguments = typeArray;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.arguments;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public String toString() {
            if (this.arguments.length == 0) {
                return this.rawType.toString();
            }
            return String.valueOf(this.rawType) + "<" + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(this.arguments).map(type -> type.toString()).toArray(String[]::new)) + ">";
        }

        public boolean equals(Object object) {
            if (!(object instanceof ParameterizedType)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            ParameterizedType parameterizedType = (ParameterizedType)object;
            return null == parameterizedType.getOwnerType() && Objects.equals(this.rawType, parameterizedType.getRawType()) && Arrays.equals(this.arguments, parameterizedType.getActualTypeArguments());
        }
    }
}

