/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.TransformingIterator;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.TransformingSpliterator;

public class TransformingCollection<InternalV, ExternalV>
implements Collection<ExternalV> {
    protected final Function<? super InternalV, ? extends ExternalV> readTransformation;
    protected final Function<? super ExternalV, ? extends InternalV> writeTransformation;
    protected final Function<Object, Object> searchTransformation;
    protected final Collection<InternalV> internalCollection;

    public TransformingCollection(Collection<InternalV> collection, Function<? super InternalV, ? extends ExternalV> function, Function<? super ExternalV, ? extends InternalV> function2, Function<Object, Object> function3) {
        this.internalCollection = collection;
        this.readTransformation = function;
        this.writeTransformation = function2;
        this.searchTransformation = function3;
    }

    @Override
    public int size() {
        return this.internalCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalCollection.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.internalCollection.contains(this.searchTransformation.apply(object));
    }

    @Override
    public Iterator<ExternalV> iterator() {
        return new TransformingIterator<InternalV, ExternalV>(this.internalCollection.iterator(), this.readTransformation);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = this.internalCollection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.readTransformation.apply(objectArray[i]);
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        T[] TArray2 = this.internalCollection.toArray(TArray);
        for (int i = 0; i < TArray2.length; ++i) {
            TArray2[i] = this.readTransformation.apply(TArray2[i]);
        }
        return TArray2;
    }

    @Override
    public boolean add(ExternalV ExternalV) {
        return this.internalCollection.add(this.writeTransformation.apply(ExternalV));
    }

    @Override
    public boolean remove(Object object) {
        return this.internalCollection.remove(this.searchTransformation.apply(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.internalCollection.containsAll(new TransformingCollection<Object, Object>(collection, this.searchTransformation, object -> object, this.searchTransformation));
    }

    @Override
    public boolean addAll(Collection<? extends ExternalV> collection) {
        return this.internalCollection.addAll(new TransformingCollection<ExternalV, InternalV>(collection, this.writeTransformation, this.readTransformation, this.searchTransformation));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.internalCollection.removeAll(new TransformingCollection<Object, Object>(collection, this.searchTransformation, object -> object, this.searchTransformation));
    }

    @Override
    public boolean removeIf(Predicate<? super ExternalV> predicate) {
        return this.internalCollection.removeIf((? super E object) -> predicate.test((ExternalV)this.readTransformation.apply(object)));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.internalCollection.retainAll(new TransformingCollection<Object, Object>(collection, this.searchTransformation, object -> object, this.searchTransformation));
    }

    @Override
    public void clear() {
        this.internalCollection.clear();
    }

    @Override
    public Spliterator<ExternalV> spliterator() {
        return new TransformingSpliterator<InternalV, ExternalV>(this.internalCollection.spliterator(), this.readTransformation, this.writeTransformation);
    }

    @Override
    public Stream<ExternalV> stream() {
        return this.internalCollection.stream().map(this.readTransformation);
    }

    @Override
    public Stream<ExternalV> parallelStream() {
        return this.internalCollection.parallelStream().map(this.readTransformation);
    }

    @Override
    public void forEach(Consumer<? super ExternalV> consumer) {
        this.internalCollection.forEach((? super T object) -> consumer.accept((ExternalV)this.readTransformation.apply(object)));
    }

    @Override
    public int hashCode() {
        return this.internalCollection.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.internalCollection.equals(object);
    }

    public String toString() {
        return this.internalCollection.toString();
    }
}

