/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.toml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableCommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.CharacterOutput;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.WritingException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.ArrayWriter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.TomlWriter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.ValueWriter;

final class TableWriter {
    private static final char[] KEY_VALUE_SEPARATOR = new char[]{' ', '=', ' '};
    private static final char[] INLINE_ENTRY_SEPARATOR = ArrayWriter.ELEMENT_SEPARATOR;
    private static final char[] ARRAY_OF_TABLES_NAME_BEGIN = new char[]{'[', '['};
    private static final char[] ARRAY_OF_TABLES_NAME_END = new char[]{']', ']'};
    private static final char[] TABLE_NAME_BEGIN = new char[]{'['};
    private static final char[] TABLE_NAME_END = new char[]{']'};

    static void writeInline(UnmodifiableConfig unmodifiableConfig, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        characterOutput.write('{');
        Iterator<? extends UnmodifiableConfig.Entry> iterator = unmodifiableConfig.entrySet().iterator();
        while (iterator.hasNext()) {
            UnmodifiableConfig.Entry entry = iterator.next();
            String string = entry.getKey();
            Object t = entry.getValue();
            tomlWriter.writeKey(string, characterOutput);
            characterOutput.write(KEY_VALUE_SEPARATOR);
            ValueWriter.write(t, characterOutput, tomlWriter);
            if (!iterator.hasNext()) continue;
            characterOutput.write(INLINE_ENTRY_SEPARATOR);
        }
        characterOutput.write('}');
    }

    static void writeTopLevel(UnmodifiableConfig unmodifiableConfig, List<String> list, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        UnmodifiableCommentedConfig unmodifiableCommentedConfig = UnmodifiableCommentedConfig.fake(unmodifiableConfig);
        TableWriter.writeWithHeader(unmodifiableCommentedConfig, null, false, false, list, characterOutput, tomlWriter);
    }

    static OrganizedTable prepareTable(UnmodifiableCommentedConfig unmodifiableCommentedConfig, String string, TomlWriter tomlWriter) {
        ArrayList<UnmodifiableCommentedConfig.Entry> arrayList = new ArrayList<UnmodifiableCommentedConfig.Entry>();
        ArrayList<UnmodifiableCommentedConfig.Entry> arrayList2 = new ArrayList<UnmodifiableCommentedConfig.Entry>();
        ArrayList<UnmodifiableCommentedConfig.Entry> arrayList3 = new ArrayList<UnmodifiableCommentedConfig.Entry>();
        for (UnmodifiableCommentedConfig.Entry entry : unmodifiableCommentedConfig.entrySet()) {
            Object object;
            Object t = entry.getValue();
            if (t instanceof UnmodifiableCommentedConfig) {
                object = (UnmodifiableConfig)t;
                if (tomlWriter.writesInline((UnmodifiableConfig)object)) {
                    arrayList.add(entry);
                    continue;
                }
                arrayList2.add(entry);
                continue;
            }
            if (t instanceof List) {
                object = (List)t;
                if (!object.isEmpty()) {
                    if (object.stream().allMatch(UnmodifiableConfig.class::isInstance)) {
                        arrayList3.add(entry);
                        continue;
                    }
                }
                arrayList.add(entry);
                continue;
            }
            arrayList.add(entry);
        }
        return new OrganizedTable(string, arrayList, arrayList2, arrayList3);
    }

    private static void writeWithHeader(UnmodifiableCommentedConfig unmodifiableCommentedConfig, String string, boolean bl, boolean bl2, List<String> list, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        boolean bl3;
        OrganizedTable organizedTable = TableWriter.prepareTable(unmodifiableCommentedConfig, string, tomlWriter);
        boolean bl4 = bl3 = !organizedTable.subTables.isEmpty();
        if (organizedTable.canBeSkipped() && tomlWriter.isHidingRedundantLevels()) {
            tomlWriter.increaseIndentLevel();
            if (bl) {
                TableWriter.writeTableArrayName(list, characterOutput, tomlWriter);
                tomlWriter.writeNewline(characterOutput);
                tomlWriter.increaseIndentLevel();
            }
            TableWriter.writeSubTables(organizedTable, list, characterOutput, tomlWriter);
            if (bl) {
                tomlWriter.decreaseIndentLevel();
            }
            if (!organizedTable.comment.isEmpty()) {
                tomlWriter.writeIndentedComment(string, characterOutput);
            }
            TableWriter.writeArraysOfTables(organizedTable, list, characterOutput, tomlWriter);
            tomlWriter.decreaseIndentLevel();
        } else {
            if (!organizedTable.comment.isEmpty()) {
                tomlWriter.writeIndentedComment(string, characterOutput);
            }
            if (bl) {
                TableWriter.writeTableArrayName(list, characterOutput, tomlWriter);
                tomlWriter.writeNewline(characterOutput);
            } else if (bl2) {
                TableWriter.writeTableName(list, characterOutput, tomlWriter);
                tomlWriter.writeNewline(characterOutput);
            }
            tomlWriter.increaseIndentLevel();
            for (UnmodifiableCommentedConfig.Entry entry : organizedTable.simples) {
                tomlWriter.writeIndentedComment(entry.getComment(), characterOutput);
                tomlWriter.writeIndentedKey(entry.getKey(), characterOutput);
                characterOutput.write(KEY_VALUE_SEPARATOR);
                ValueWriter.write(entry.getValue(), characterOutput, tomlWriter);
                tomlWriter.writeNewline(characterOutput);
            }
            if (bl3) {
                tomlWriter.writeNewline(characterOutput);
            }
            TableWriter.writeSubTables(organizedTable, list, characterOutput, tomlWriter);
            TableWriter.writeArraysOfTables(organizedTable, list, characterOutput, tomlWriter);
            tomlWriter.decreaseIndentLevel();
        }
    }

    private static void writeSubTables(OrganizedTable organizedTable, List<String> list, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        boolean bl = !organizedTable.arraysOfTables.isEmpty();
        Iterator<UnmodifiableCommentedConfig.Entry> iterator = organizedTable.subTables.iterator();
        while (iterator.hasNext()) {
            UnmodifiableCommentedConfig.Entry entry = iterator.next();
            UnmodifiableCommentedConfig unmodifiableCommentedConfig = UnmodifiableCommentedConfig.fake((UnmodifiableConfig)entry.getRawValue());
            list.add(entry.getKey());
            TableWriter.writeWithHeader(unmodifiableCommentedConfig, entry.getComment(), false, true, list, characterOutput, tomlWriter);
            list.remove(list.size() - 1);
            if (!bl && !iterator.hasNext()) continue;
            tomlWriter.writeNewline(characterOutput);
        }
    }

    private static void writeArraysOfTables(OrganizedTable organizedTable, List<String> list, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        Iterator<UnmodifiableCommentedConfig.Entry> iterator = organizedTable.arraysOfTables.iterator();
        while (iterator.hasNext()) {
            UnmodifiableCommentedConfig.Entry entry = iterator.next();
            list.add(entry.getKey());
            List list2 = (List)entry.getRawValue();
            for (UnmodifiableConfig unmodifiableConfig : list2) {
                TableWriter.writeWithHeader(UnmodifiableCommentedConfig.fake(unmodifiableConfig), entry.getComment(), true, true, list, characterOutput, tomlWriter);
            }
            list.remove(list.size() - 1);
            if (!iterator.hasNext()) continue;
            tomlWriter.writeNewline(characterOutput);
        }
    }

    private static void writeTableArrayName(List<String> list, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        TableWriter.writeTableName(list, characterOutput, tomlWriter, ARRAY_OF_TABLES_NAME_BEGIN, ARRAY_OF_TABLES_NAME_END);
    }

    private static void writeTableName(List<String> list, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        TableWriter.writeTableName(list, characterOutput, tomlWriter, TABLE_NAME_BEGIN, TABLE_NAME_END);
    }

    private static void writeTableName(List<String> list, CharacterOutput characterOutput, TomlWriter tomlWriter, char[] cArray, char[] cArray2) {
        if (list.isEmpty()) {
            throw new WritingException("Invalid empty table name.");
        }
        tomlWriter.writeIndent(characterOutput);
        characterOutput.write(cArray);
        Iterator<String> iterator = list.iterator();
        tomlWriter.writeKey(iterator.next(), characterOutput);
        while (iterator.hasNext()) {
            characterOutput.write('.');
            tomlWriter.writeKey(iterator.next(), characterOutput);
        }
        characterOutput.write(cArray2);
    }

    private TableWriter() {
    }

    static class OrganizedTable {
        List<UnmodifiableCommentedConfig.Entry> simples;
        List<UnmodifiableCommentedConfig.Entry> subTables;
        List<UnmodifiableCommentedConfig.Entry> arraysOfTables;
        String comment;

        OrganizedTable(String string, List<UnmodifiableCommentedConfig.Entry> list, List<UnmodifiableCommentedConfig.Entry> list2, List<UnmodifiableCommentedConfig.Entry> list3) {
            this.comment = string == null ? "" : string;
            this.simples = list;
            this.subTables = list2;
            this.arraysOfTables = list3;
        }

        boolean canBeSkipped() {
            return !(!this.comment.isEmpty() && this.arraysOfTables.isEmpty() || !this.simples.isEmpty() || this.subTables.isEmpty() && this.arraysOfTables.isEmpty());
        }

        public String toString() {
            return "OrganizedTable [simples=" + String.valueOf(this.simples) + ", subTables=" + String.valueOf(this.subTables) + ", arraysOfTables=" + String.valueOf(this.arraysOfTables) + ", comment=" + this.comment + ", canBeSkipped()=" + this.canBeSkipped() + "]";
        }
    }
}

