/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.toml;

import java.time.temporal.Temporal;
import java.util.Map;
import java.util.function.Supplier;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.FormatDetector;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.TomlParser;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.TomlWriter;

public final class TomlFormat
implements ConfigFormat<CommentedConfig> {
    private static final TomlFormat INSTANCE = new TomlFormat();

    public static TomlFormat instance() {
        return INSTANCE;
    }

    public static CommentedConfig newConfig() {
        return (CommentedConfig)INSTANCE.createConfig();
    }

    public static CommentedConfig newConfig(Supplier<Map<String, Object>> supplier) {
        return INSTANCE.createConfig((Supplier)supplier);
    }

    public static CommentedConfig newConcurrentConfig() {
        return (CommentedConfig)INSTANCE.createConcurrentConfig();
    }

    private TomlFormat() {
    }

    @Override
    public TomlWriter createWriter() {
        return new TomlWriter();
    }

    public TomlParser createParser() {
        return new TomlParser();
    }

    @Override
    public CommentedConfig createConfig(Supplier<Map<String, Object>> supplier) {
        return CommentedConfig.of(supplier, this);
    }

    @Override
    public boolean supportsComments() {
        return true;
    }

    @Override
    public boolean supportsType(Class<?> clazz) {
        return clazz != null && (ConfigFormat.super.supportsType(clazz) || Temporal.class.isAssignableFrom(clazz));
    }

    static {
        FormatDetector.registerExtension("toml", INSTANCE);
    }
}

