/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.toml;

import java.time.temporal.Temporal;
import java.util.List;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.NullObject;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.CharacterOutput;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.WritingException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.ArrayWriter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.StringWriter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.TableWriter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.TemporalWriter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.toml.TomlWriter;

final class ValueWriter {
    private static void writeString(String string, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        if (tomlWriter.writesLiteral(string)) {
            if (tomlWriter.writesMultiline(string)) {
                StringWriter.writeLiteralMultiline(string, characterOutput);
            } else {
                StringWriter.writeLiteral(string, characterOutput);
            }
        } else if (tomlWriter.writesMultiline(string)) {
            StringWriter.writeBasicMultiline(string, characterOutput, tomlWriter);
        } else {
            StringWriter.writeBasic(string, characterOutput);
        }
    }

    static void write(Object object, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        if (object instanceof Config) {
            TableWriter.writeInline((Config)object, characterOutput, tomlWriter);
        } else if (object instanceof List) {
            ArrayWriter.write((List)object, characterOutput, tomlWriter);
        } else if (object instanceof CharSequence) {
            ValueWriter.writeString(object.toString(), characterOutput, tomlWriter);
        } else if (object instanceof Enum) {
            ValueWriter.writeString(((Enum)object).name(), characterOutput, tomlWriter);
        } else if (object instanceof Temporal) {
            TemporalWriter.write((Temporal)object, characterOutput);
        } else if (object instanceof Float || object instanceof Double) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d)) {
                characterOutput.write("nan");
            } else if (d == Double.POSITIVE_INFINITY) {
                characterOutput.write("+inf");
            } else if (d == Double.NEGATIVE_INFINITY) {
                characterOutput.write("-inf");
            } else {
                characterOutput.write(object.toString());
            }
        } else if (object instanceof Number || object instanceof Boolean) {
            characterOutput.write(object.toString());
        } else {
            if (object == null || object == NullObject.NULL_OBJECT) {
                throw new WritingException("TOML doesn't support null values");
            }
            throw new WritingException("Unsupported value type: " + String.valueOf(object.getClass()));
        }
    }

    private ValueWriter() {
    }
}

