/*
 * Decompiled with CFR 0.152.
 */
package net.hicham.sleepreminder;

import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class SleepReminderMod
implements ModInitializer {
    private boolean hasReminded = false;
    private boolean showPopup = false;
    private int popupDisplayTime = 0;
    private static final int MAX_POPUP_TIME = 100;

    public void onInitialize() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null || client.field_1724 == null) {
                this.showPopup = false;
                this.popupDisplayTime = 0;
                return;
            }
            long time = client.field_1687.method_8532() % 24000L;
            if (time > 13000L && time < 23000L) {
                if (!this.hasReminded) {
                    this.showPopup = true;
                    this.popupDisplayTime = 100;
                    this.hasReminded = true;
                }
            } else {
                this.hasReminded = false;
                this.showPopup = false;
                this.popupDisplayTime = 0;
            }
            if (this.showPopup && this.popupDisplayTime > 0) {
                --this.popupDisplayTime;
                if (this.popupDisplayTime <= 0) {
                    this.showPopup = false;
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (this.showPopup && this.popupDisplayTime > 0) {
                this.renderPopup(drawContext, class_310.method_1551());
            }
        });
    }

    private void renderPopup(class_332 drawContext, class_310 client) {
        class_327 textRenderer = client.field_1772;
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        int x = width / 2;
        int y = height / 8;
        class_5250 text = class_2561.method_43470((String)"\u00a7e[Sleep Reminder] \u00a7fSleep before mobs come!");
        int textWidth = textRenderer.method_27525((class_5348)text);
        int bgPadding = 5;
        int bgColor = Integer.MIN_VALUE;
        int bgX = x - textWidth / 2 - bgPadding;
        int bgY = y - bgPadding;
        int bgWidth = textWidth + bgPadding * 2;
        Objects.requireNonNull(textRenderer);
        int bgHeight = 9 + bgPadding * 2;
        drawContext.method_25294(bgX, bgY, bgX + bgWidth, bgY + bgHeight, bgColor);
        drawContext.method_27535(textRenderer, (class_2561)text, x - textWidth / 2, y, -1);
    }
}

