/*
 * This class is modified from the PSI mod created by Vazkii
 * Psi Source Code: https://github.com/Vazkii/Psi
 *
 * Psi is Open Source and distributed under the
 * Psi License: https://psi.vazkii.net/license.php
 *
 * HVB007: IDK What Part This credit refers to, if you want to know contact https://github.com/CaelTheColher as he is the maker of this mod
 * I am just updating it to 1.20.x
 */
package me.av306.keybindsgaloreplus;

import com.mojang.blaze3d.systems.RenderSystem;

import static me.av306.keybindsgaloreplus.KeybindsGalorePlus.customDataManager;

import me.av306.keybindsgaloreplus.mixin.KeyBindingAccessor;
import me.av306.keybindsgaloreplus.mixin.MinecraftClientAccessor;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.client.render.*;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.Objects;

public class KeybindSelectorScreen extends class_437
{
    // Instance variables
    private int ticksInScreen = 0;
    private int selectedSectorIndex = -1;
    private boolean mouseDown = false;

    private final class_3675.class_306 conflictedKey;

    private final class_310 mc;

    private int centreX = 0, centreY = 0;

    private float maxRadius = 0;
    private float maxExpandedRadius = 0;
    private float cancelZoneRadius = 0;

    private boolean isFirstFrame = true;

    /** This is probably not going to change while the screen is open, so maybe this optimisation helps? */
    private final ArrayList<class_304> conflicts = new ArrayList<>();

    /*public KeybindSelectorScreen()
    {
        super( NarratorManager.EMPTY );
        this.mc = MinecraftClient.getInstance();

        // Debug -- print all fields
        for ( var f : this.getClass().getFields() )
        {
            try
            {
                KeybindsGalorePlus.LOGGER.info( "{}: {}", f.getName(), f.get( this ) );
            }
            catch ( IllegalAccessException e )
            {
                KeybindsGalorePlus.LOGGER.warn( e.getMessage() );
            }
        }
    }*/

    public KeybindSelectorScreen( class_3675.class_306 key )
    {
        //this();
        super( class_333.field_18967 );
        this.mc = class_310.method_1551();

        this.conflictedKey = key;

        this.conflicts.addAll( KeybindManager.getConflicts( key ) );
    }

    @Override
    public void method_25394( class_332 context, int mouseX, int mouseY, float delta )
    {
        // ===== Version dependent =====
        //super.render( context, mouseX, mouseY, delta );
        this.method_25420( context, mouseX, mouseY, delta );
        //this.renderBackground( context );

        // Pixel coords of screen centre
        // Only set these on the first frame
        // Side effect: If window is resized when the screen is open, the menu won't update
        if ( this.isFirstFrame )
        {
            // Set centre of screen
            this.centreX = this.field_22789 / 2;
            this.centreY = this.field_22790 / 2;

            this.maxRadius = Math.min( (this.centreX * Configurations.PIE_MENU_SCALE) - Configurations.PIE_MENU_MARGIN, (this.centreY * Configurations.PIE_MENU_SCALE) - Configurations.PIE_MENU_MARGIN );
            this.maxExpandedRadius = this.maxRadius * Configurations.EXPANSION_FACTOR_WHEN_SELECTED;
            this.cancelZoneRadius = maxRadius * Configurations.CANCEL_ZONE_SCALE;

            this.isFirstFrame = false;
        }

        // Angle of mouse, in radians from +X-axis, centred on the origin
        double mouseAngle = mouseAngle( this.centreX, this.centreY, mouseX, mouseY );

        float mouseDistanceFromCentre = class_3532.method_15355( (mouseX - this.centreX) * (mouseX - this.centreX) +
                        (mouseY - this.centreY) * (mouseY - this.centreY) );

        // Determines how many sectors to make for the pie menu
        int numberOfSectors = this.conflicts.size();

        // Calculate the angle occupied by each sector
        float sectorAngle = (class_3532.field_29846) / numberOfSectors;

        // Get the exact sector index that is selected
        this.selectedSectorIndex = (int) (mouseAngle / sectorAngle);

        // Deselect slot if mouse is within cancel zone
        if ( mouseDistanceFromCentre <= this.cancelZoneRadius )
            this.selectedSectorIndex = -1;
        
        this.renderPieMenu( context, delta, numberOfSectors, sectorAngle );
        this.renderLabelTexts( context, delta, numberOfSectors, sectorAngle );
    }


    // ==================== Rendering methods ====================

    private void renderPieMenu( class_332 context, float delta, int numberOfSectors, float sectorAngle )
    {
        // I can't figure out how to make this work. Neither BufferRenderer nor SpecialGuiElementRenderer exist...
    }

    private void drawSector( class_287 buf, float startAngle, float sectorAngle, int vertices, float innerRadius, float outerRadius,
                             int innerColor, int outerColor )
    {
        for ( var i = 0; i <= vertices; i++ )
        {
            float angle = startAngle + ((float) i / vertices) * sectorAngle;

            // ===== Version dependent =====
            // Inner vertex
            // FIXME: is the compiler smart enough to optimise the trigo?
            buf.method_22912( this.centreX + class_3532.method_15362( angle ) * innerRadius, this.centreY + class_3532.method_15374( angle ) * innerRadius, 0 );
            buf.method_1336( innerColor >> 16 & 0xFF, innerColor >> 8 & 0xFF, innerColor & 0xFF, Configurations.PIE_MENU_ALPHA );
            //buf.next(); //* <1.21

            // Outer vertex
            buf.method_22912( this.centreX + class_3532.method_15362( angle ) * outerRadius, this.centreY + class_3532.method_15374( angle ) * outerRadius, 0 );
            buf.method_1336( outerColor >> 16 & 0xFF, outerColor >> 8 & 0xFF, outerColor & 0xFF, Configurations.PIE_MENU_ALPHA );
            //buf.next(); //* <1.21
        }
    }

    private float calculateRadius( float delta, int numberOfSectors, int sectorIndex )
    {
        float radius = Configurations.ANIMATE_PIE_MENU ?
                Math.max( 0f, Math.min( (this.ticksInScreen + delta - sectorIndex * 6f / numberOfSectors) * 40f, this.maxRadius ) ) :
                this.maxRadius;

        // Expand the sector if selected
        if ( this.selectedSectorIndex == sectorIndex ) radius *= Configurations.EXPANSION_FACTOR_WHEN_SELECTED;

        return radius;
    }

    private void renderLabelTexts(
            class_332 context,
            float delta,
            int numberOfSectors, float sectorAngle
    )
    {
        for ( var sectorIndex = 0; sectorIndex < numberOfSectors; sectorIndex++ )
        {
            float radius = calculateRadius( delta, numberOfSectors, sectorIndex );
            
            float angle = (sectorIndex + 0.5f) * sectorAngle;

            // Position in the middle of the arc
            float xPos = this.centreX + class_3532.method_15362( angle ) * radius;
            float yPos = this.centreY + class_3532.method_15374( angle ) * radius;

            class_304 action = this.conflicts.get( sectorIndex );

            // The biggest nagging bug for me
            // Tells you which control category the action goes in
            // TODO: configurable

            String id = action.method_1431();
            String actionName = class_2561.method_43471( action.method_1423() ).getString() + ": " + class_2561.method_43471( action.method_1431() ).getString();

            // Read custom data for this keybind, only if present
            if ( customDataManager.hasCustomData )
            {
                try
                {
                    if ( customDataManager.customData.get( id ).hideCategory )
                        actionName = class_2561.method_43471( action.method_1431() ).getString();
                }
                catch ( NullPointerException npe )
                {
                    //KeybindsGalorePlus.debugLog( "No hideCategory setting for {}", id );
                }

                try
                {
                    // Assigning `null` doesn't throw an NPE, so we wrap with this to throw one
                    actionName = Objects.requireNonNull( customDataManager.customData.get( id ).displayName );
                }
                catch ( NullPointerException npe )
                {
                    //KeybindsGalorePlus.debugLog( "No custom name for {}", id );
                }
            }

            int textWidth = this.field_22793.method_1727( actionName );

            // Which side of the screen are we on?
            if ( xPos > this.centreX ) // Right side
            {
                xPos -= Configurations.LABEL_TEXT_INSET;

                // Check text going off-screen
                if ( this.field_22789 - xPos < textWidth )
                    xPos -= textWidth - this.field_22789 + xPos;
            }
            else // Left side
            {

                xPos -= textWidth - Configurations.LABEL_TEXT_INSET;

                // Check text going off-screen
                if ( xPos < 0 ) xPos = Configurations.LABEL_TEXT_INSET;
            }

            // Move the text closer to the centre of the circle
            yPos -= Configurations.LABEL_TEXT_INSET;

            actionName = (this.selectedSectorIndex == sectorIndex ? class_124.field_1073 : class_124.field_1070) + actionName;

            context.method_51433( this.field_22793, actionName, (int) xPos, (int) yPos, 0xFFFFFF, Configurations.LABEL_TEXT_SHADOW );
        }
    }


    // ==================== Others // ====================

    // Returns the angle of the line bounded by the given coordinates and the mouse position from the vertical axis
    // This is why we study trigo, guys
    private static double mouseAngle( int x, int y, int mx, int my )
    {
        return (class_3532.method_15349(my - y, mx - x) + Math.PI * 2) % (Math.PI * 2);
    }

    private void closePieMenu()
    {
        this.mc.method_1507( null );

        // Activate the selected binding
        if ( this.selectedSectorIndex != -1 )
        {
            class_304 selectedKeyBinding = this.conflicts.get( this.selectedSectorIndex );

            KeybindsGalorePlus.debugLog( "Activated {} from pie menu", selectedKeyBinding.method_1431() );

            ((KeyBindingAccessor) selectedKeyBinding).setPressed( true );
            ((KeyBindingAccessor) selectedKeyBinding).setTimesPressed( 1 );
            //((KeyBindingAccessor) bind).invokeSetPressed( true );

            // Attack workaround (very hacky)
            // Abusable??? (FIXME)
            if ( selectedKeyBinding.method_1435( this.mc.field_1690.field_1886 ) && Configurations.ENABLE_ATTACK_WORKAROUND )
            {
                KeybindsGalorePlus.debugLog( "\tAttack workaround enabled" );
                ((MinecraftClientAccessor) this.mc).setAttackCooldown( 0 );
            }
        }
        else
        {
            KeybindsGalorePlus.debugLog( "Pie menu closed with no selection" );
        }
    }


    // ==================== Overrides // ====================

    @Override
    public void method_25393()
    {
        // There's literally nothing there. Avoid the jump instructions.
        // super.tick();
        this.ticksInScreen++;
    }

    // These two callbacks work the same as handling it in tick(), plus we get differentiated mouse/keyboard handling
    // Previously, InputUtil.isKeyPressed would throw a GL error when called for a mouse code (0, 1, 2) and return a meaningless value

    @Override
    public boolean method_16803( int keyCode, int scanCode, int modifiers )
    {
        if ( keyCode == this.conflictedKey.method_1444() ) this.closePieMenu();

        return super.method_16803( keyCode, scanCode, modifiers );
    }

    @Override
    public boolean method_25406( double mouseX, double mouseY, int button )
    {
        //this.mouseDown = false;

        if ( button == this.conflictedKey.method_1444() )
        {
            // Close menu and activate selection normally – click-hold not applicable
            this.closePieMenu();
        }
        else
        {
            // Click-hold selected binding

            this.mc.method_1507( null );
            class_304.method_1437(); // This stops the other actions from triggering. Not sure why they do in the first place, though.

            if ( this.selectedSectorIndex != -1 )
            {
                class_304 binding = this.conflicts.get( this.selectedSectorIndex );

                // Clicked on a sector; add its binding to the click-hold map
                //KeybindsGalorePlus.debugLog( "Activated sector {} (key {}) (click-hold) via pie menu", this.selectedSectorIndex, this.conflictedKey.getCategory() );
                KeybindsGalorePlus.debugLog( "Pie menu closed with click-hold" );
                KeybindManager.clickHoldKeys.put(
                        this.conflictedKey.method_1444(),
                        binding
                );

                // Key events are generated repeatedly for keyboard keys held down, but not for mouse buttons,
                // so we have to make one manually
                if ( this.conflictedKey.method_1444() <= GLFW.GLFW_MOUSE_BUTTON_LAST )
                    binding.method_23481( true );
            }
            else
            {
                KeybindsGalorePlus.debugLog( "Pie menu closed via click-hold with no selection" );
                // No sector clicked; add null to the click-hold map to signal a cancel
                KeybindManager.clickHoldKeys.put( this.conflictedKey.method_1444(), null );
            }
        }

        return super.method_25406( mouseX, mouseY, button );
    }

    @Override
    public boolean method_25402( double mouseX, double mouseY, int button )
    {
        this.mouseDown = true;

        return super.method_25402( mouseX, mouseY, button );
    }

    @Override
    // Don't pause the game when this screen is open
    // actually why not
    public boolean method_25421() { return false; }


    //* >=1.20.2
    @Override
    public void method_25420( class_332 context, int mouseX, int mouseY, float delta )
    {
        // Remove the darkened background if needed
        // This can help performance, as with all post-processing
        if ( Configurations.DARKENED_BACKGROUND ) super.method_25420( context, mouseX, mouseY, delta ); //* >=1.20.2
    }

    //* <1.20.2
    // Annoyingly, we can have the method in >1.20.2 but not the super call :(
    //@Override
    // public void renderBackground( DrawContext context ) //* <1.20.2
    // {
    //     //* // ===== Version dependent =====
    //     // Remove the darkened background if needed
    //     // This can help performance, as with all post-processing
    //     if ( Configurations.DARKENED_BACKGROUND ) super.renderBackground( context ); //* <1.20.2
    // }
}
