package me.av306.keybindsgaloreplus;

import me.av306.keybindsgaloreplus.configmanager.ConfigManager;
import me.av306.keybindsgaloreplus.customdata.DataManager;
import me.av306.keybindsgaloreplus.mixin.KeyBindingAccessor;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import java.io.IOException;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class KeybindsGalorePlus implements ClientModInitializer
{
    public static ConfigManager configManager;
    public static DataManager customDataManager;

    public static final Logger LOGGER = LoggerFactory.getLogger( "keybingsgaloreplus" );

    private static class_304 configreloadKeybind;

    @Override
    public void onInitializeClient()
    {
        LOGGER.info( "KeybindsGalore Plus initialising..." );

        try
        {
            // Initialise ConfigManager and load config file
            configManager = new ConfigManager(
                "KeybindsGalorePlus",    
                FabricLoader.getInstance().getConfigDir(),
                "keybindsgaloreplus_config.properties",
                Configurations.class,
                null
            );

            // There's no good, easy way to enable DEBUG level, so I'm just gonna
            // cram a bunch of if statements around
            LOGGER.info( "Debug mode: {}", Configurations.DEBUG );

            // (debug) Print all config fields
            if ( Configurations.DEBUG )
            {
                this.configManager.printAllConfigs();
            }

            // Initialise custom data manager and read data file
            customDataManager = new DataManager(
                    FabricLoader.getInstance().getConfigDir(),
                    "keybindsgaloreplus_customdata.data"
            );


            // Set config reload key
            configreloadKeybind = KeyBindingHelper.registerKeyBinding( new class_304(
                    "key.keybindsgaloreplus.reloadconfigs",
                    class_3675.class_307.field_1668,
                    GLFW.GLFW_KEY_UNKNOWN,
                    "category.keybindsgaloreplus.keybinds"
            ) );

            // Bind action to config reload key
            ClientTickEvents.END_CLIENT_TICK.register( client ->
            {
                while ( configreloadKeybind.method_1436() )
                {
                    try
                    {
                        configManager.readConfigFile();
                        customDataManager.readDataFile();
                    }
                    catch ( IOException firstIoe )
                    {
                        client.field_1724.method_7353( class_2561.method_43469( "text.keybindsgaloreplus.configreloadfail", firstIoe.getMessage() ), false );

                        return;
                    }

                    if ( configManager.errorFlag ) client.field_1724.method_7353( class_2561.method_43471( "text.keybindsgaloreplus.configerrors" ).method_27692( class_124.field_1061 ), false );
                    if ( customDataManager.hasCustomData ) client.field_1724.method_7353( class_2561.method_43471( "text.keybindsgaloreplus.customdatafound" ), false );

                    client.field_1724.method_7353( class_2561.method_43471( "text.keybindsgaloreplus.configreloaded" ), false );

                    if ( Configurations.DEBUG )
                    {
                        // Print all config fields
                        this.configManager.printAllConfigs();                        
                    }
                }
            } );


        }
        catch ( IOException ioe )
        {
            LOGGER.error( "(KBG+) IOException while reading config file on init!" );
            ioe.printStackTrace();
        }

        // Find conflicts on first world join
        ClientPlayConnectionEvents.JOIN.register( (handler, sender, client) -> KeybindManager.findAllConflicts() );
    }

    public static void debugLog( String message )
    {
        if ( Configurations.DEBUG ) LOGGER.info( "(KBG+ DEBUG) " + message );
    }

    public static void debugLog( String message, Object... objects )
    {
        if ( Configurations.DEBUG ) LOGGER.info( "(KBG+ DEBUG) " + message, objects );
    }

    public static class_2561 createHyperlinkText( String url )
    {
        return class_2561.method_43470( url )
                .method_27692( class_124.field_1054 )
                .method_27694( style -> style.method_10958( new class_2558( class_2558.class_2559.field_11749, url ) ) );
    }
}
