/*
 * Decompiled with CFR 0.152.
 */
package me.av306.keybindsgaloreplus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import me.av306.keybindsgaloreplus.Configurations;
import me.av306.keybindsgaloreplus.KeybindSelectorScreen;
import me.av306.keybindsgaloreplus.KeybindsGalorePlus;
import me.av306.keybindsgaloreplus.mixin.KeyBindingAccessor;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class KeybindManager {
    public static final Hashtable<class_3675.class_306, List<class_304>> conflictTable = new Hashtable();
    public static final HashMap<Integer, class_304> clickHoldKeys = new HashMap();

    public static void findAllConflicts() {
        KeybindsGalorePlus.LOGGER.info("(KBG+) Performing lazy conflict check");
        class_310 client = class_310.method_1551();
        conflictTable.clear();
        for (class_304 keybinding : client.field_1690.field_1839) {
            class_3675.class_306 physicalKey = ((KeyBindingAccessor)keybinding).getBoundKey();
            if (physicalKey.method_1444() == -1) continue;
            conflictTable.computeIfAbsent(physicalKey, key -> new ArrayList());
            conflictTable.get(physicalKey).add(keybinding);
        }
        new HashSet<class_3675.class_306>(conflictTable.keySet()).forEach(key -> {
            if (conflictTable.get(key).size() < 2) {
                conflictTable.remove(key);
            }
        });
        if (Configurations.DEBUG) {
            KeybindsGalorePlus.LOGGER.info("Dumping key conflict table");
            conflictTable.values().forEach(list -> list.forEach(binding -> KeybindsGalorePlus.LOGGER.info("\t{} bound to physical key {}", (Object)binding.method_1431(), (Object)((KeyBindingAccessor)binding).getBoundKey())));
        }
    }

    public static boolean isIgnoredKey(class_3675.class_306 key) {
        return Configurations.IGNORED_KEYS.contains(key.method_1444()) ^ Configurations.INVERT_IGNORED_KEYS_LIST;
    }

    public static boolean isClickHoldKey(class_3675.class_306 key) {
        return clickHoldKeys.containsKey(key.method_1444());
    }

    public static boolean hasConflicts(class_3675.class_306 key) {
        return conflictTable.containsKey(key);
    }

    public static void openConflictMenu(class_3675.class_306 key) {
        KeybindSelectorScreen screen = new KeybindSelectorScreen(key);
        class_310.method_1551().method_1507((class_437)screen);
    }

    public static List<class_304> getConflicts(class_3675.class_306 key) {
        return conflictTable.get(key);
    }

    public static void handleKeyPress(class_3675.class_306 key, boolean pressed, CallbackInfo ci) {
        if (KeybindManager.hasConflicts(key)) {
            if (KeybindManager.isClickHoldKey(key)) {
                ci.cancel();
                class_304 clickHoldBinding = clickHoldKeys.get(key.method_1444());
                if (clickHoldBinding != null) {
                    KeybindsGalorePlus.debugLog("Activating {} (click-hold)", clickHoldBinding.method_1431());
                    ((KeyBindingAccessor)clickHoldBinding).setPressed(pressed);
                    ((KeyBindingAccessor)clickHoldBinding).setTimesPressed(pressed ? 1 : 0);
                }
                if (!pressed) {
                    KeybindsGalorePlus.debugLog("Deactivating key {} (click-hold)", key.method_1441());
                    clickHoldKeys.remove(key.method_1444());
                }
            } else if (!KeybindManager.isIgnoredKey(key)) {
                ci.cancel();
                if (pressed) {
                    KeybindsGalorePlus.debugLog("\tOpening pie menu");
                    KeybindManager.openConflictMenu(key);
                }
            } else if (Configurations.USE_KEYBIND_FIX) {
                ci.cancel();
                KeybindManager.getConflicts(key).forEach(binding -> {
                    KeybindsGalorePlus.debugLog("\tVanilla fix, {} key {}", pressed ? "enabling" : "disabling", binding.method_1431());
                    if (pressed) {
                        ((KeyBindingAccessor)binding).setPressed(true);
                        ((KeyBindingAccessor)binding).setTimesPressed(1);
                    } else {
                        ((KeyBindingAccessor)binding).invokeReset();
                    }
                });
            }
        }
    }
}

