/*
 * Decompiled with CFR 0.152.
 */
package me.av306.keybindsgaloreplus;

import java.util.ArrayList;
import java.util.Objects;
import me.av306.keybindsgaloreplus.Configurations;
import me.av306.keybindsgaloreplus.KeybindManager;
import me.av306.keybindsgaloreplus.KeybindsGalorePlus;
import me.av306.keybindsgaloreplus.mixin.KeyBindingAccessor;
import me.av306.keybindsgaloreplus.mixin.MinecraftClientAccessor;
import me.av306.keybindsgaloreplus.render.KeybindSelectorElementRenderState;
import me.av306.keybindsgaloreplus.render.KeybindSelectorElementRenderer;
import net.minecraft.class_11256;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4597;

public class KeybindSelectorScreen
extends class_437 {
    private int ticksInScreen = 0;
    private int selectedSectorIndex = -1;
    private boolean mouseDown = false;
    private final class_3675.class_306 conflictedKey;
    private int centreX = 0;
    private int centreY = 0;
    private float maxRadius = 0.0f;
    private float maxExpandedRadius = 0.0f;
    private float cancelZoneRadius = 0.0f;
    private boolean isFirstFrame = true;
    private class_4597.class_4598 vertexConsumerProvider;
    private final ArrayList<class_304> conflicts = new ArrayList();

    public KeybindSelectorScreen(class_3675.class_306 key) {
        super(class_333.field_18967);
        this.conflictedKey = key;
        this.conflicts.addAll(KeybindManager.getConflicts(key));
    }

    protected void method_25426() {
        this.centreX = this.field_22789 / 2;
        this.centreY = this.field_22790 / 2;
        this.maxRadius = Math.min((float)this.centreX * Configurations.PIE_MENU_SCALE - (float)Configurations.PIE_MENU_MARGIN, (float)this.centreY * Configurations.PIE_MENU_SCALE - (float)Configurations.PIE_MENU_MARGIN);
        this.maxExpandedRadius = this.maxRadius * Configurations.EXPANSION_FACTOR_WHEN_SELECTED;
        this.cancelZoneRadius = this.maxRadius * Configurations.CANCEL_ZONE_SCALE;
        if (Configurations.DEBUG) {
            KeybindsGalorePlus.debugLog("Centre: ({}, {})", this.centreX, this.centreY);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        double mouseAngle = KeybindSelectorScreen.mouseAngle(this.centreX, this.centreY, mouseX, mouseY);
        float mouseDistanceFromCentre = class_3532.method_15355((float)((mouseX - this.centreX) * (mouseX - this.centreX) + (mouseY - this.centreY) * (mouseY - this.centreY)));
        int numberOfSectors = this.conflicts.size();
        float sectorAngle = (float)Math.PI * 2 / (float)numberOfSectors;
        this.selectedSectorIndex = (int)(mouseAngle / (double)sectorAngle);
        if (mouseDistanceFromCentre <= this.cancelZoneRadius) {
            this.selectedSectorIndex = -1;
        }
        context.field_59826.method_70922((class_11256)new KeybindSelectorElementRenderState(tickDelta, numberOfSectors, sectorAngle, this.selectedSectorIndex, this.mouseDown, this.ticksInScreen, 0, 0, this.field_22787.method_22683().method_4480(), this.field_22787.method_22683().method_4507(), null));
        this.renderLabelTexts(context, tickDelta, numberOfSectors, sectorAngle);
    }

    private void renderLabelTexts(class_332 context, float delta, int numberOfSectors, float sectorAngle) {
        for (int sectorIndex = 0; sectorIndex < numberOfSectors; ++sectorIndex) {
            float radius = KeybindSelectorElementRenderer.calculateRadius(this.ticksInScreen, delta, numberOfSectors, sectorIndex, this.selectedSectorIndex, this.maxRadius);
            float angle = ((float)sectorIndex + 0.5f) * sectorAngle;
            float xPos = (float)this.centreX + class_3532.method_15362((float)angle) * radius;
            float yPos = (float)this.centreY + class_3532.method_15374((float)angle) * radius;
            class_304 action = this.conflicts.get(sectorIndex);
            String id = action.method_1431();
            Object actionName = class_2561.method_43471((String)action.method_1423()).getString() + ": " + class_2561.method_43471((String)action.method_1431()).getString();
            if (KeybindsGalorePlus.customDataManager.hasCustomData) {
                try {
                    if (KeybindsGalorePlus.customDataManager.customData.get((Object)id).hideCategory) {
                        actionName = class_2561.method_43471((String)action.method_1431()).getString();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    actionName = Objects.requireNonNull(KeybindsGalorePlus.customDataManager.customData.get((Object)id).displayName);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            int textWidth = this.field_22793.method_1727((String)actionName);
            if (xPos > (float)this.centreX) {
                if ((float)this.field_22789 - (xPos -= (float)Configurations.LABEL_TEXT_INSET) < (float)textWidth) {
                    xPos -= (float)(textWidth - this.field_22789) + xPos;
                }
            } else if ((xPos -= (float)(textWidth - Configurations.LABEL_TEXT_INSET)) < 0.0f) {
                xPos = Configurations.LABEL_TEXT_INSET;
            }
            actionName = String.valueOf(this.selectedSectorIndex == sectorIndex ? class_124.field_1073 : class_124.field_1070) + (String)actionName;
            context.method_51433(this.field_22793, (String)actionName, (int)xPos, (int)(yPos -= (float)Configurations.LABEL_TEXT_INSET), -1, Configurations.LABEL_TEXT_SHADOW);
        }
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (class_3532.method_15349((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    private void closePieMenu() {
        this.field_22787.method_1507(null);
        if (this.selectedSectorIndex != -1) {
            class_304 selectedKeyBinding = this.conflicts.get(this.selectedSectorIndex);
            KeybindsGalorePlus.debugLog("Activated {} from pie menu", selectedKeyBinding.method_1431());
            ((KeyBindingAccessor)selectedKeyBinding).setPressed(true);
            ((KeyBindingAccessor)selectedKeyBinding).setTimesPressed(1);
            if (selectedKeyBinding.method_1435(this.field_22787.field_1690.field_1886) && Configurations.ENABLE_ATTACK_WORKAROUND) {
                KeybindsGalorePlus.debugLog("\tAttack workaround enabled");
                ((MinecraftClientAccessor)this.field_22787).setAttackCooldown(0);
            }
        } else {
            KeybindsGalorePlus.debugLog("Pie menu closed with no selection");
        }
    }

    public void method_25393() {
        ++this.ticksInScreen;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == this.conflictedKey.method_1444()) {
            this.closePieMenu();
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == this.conflictedKey.method_1444()) {
            this.closePieMenu();
        } else {
            this.field_22787.method_1507(null);
            class_304.method_1437();
            if (this.selectedSectorIndex != -1) {
                class_304 binding = this.conflicts.get(this.selectedSectorIndex);
                KeybindsGalorePlus.debugLog("Pie menu closed with click-hold");
                KeybindManager.clickHoldKeys.put(this.conflictedKey.method_1444(), binding);
                if (this.conflictedKey.method_1444() <= 7) {
                    binding.method_23481(true);
                }
            } else {
                KeybindsGalorePlus.debugLog("Pie menu closed via click-hold with no selection");
                KeybindManager.clickHoldKeys.put(this.conflictedKey.method_1444(), null);
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseDown = true;
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (this.field_22787.field_1687 == null) {
            this.method_57728(context, deltaTicks);
        }
        this.method_57734(context);
        if (Configurations.DARKENED_BACKGROUND) {
            this.method_57735(context);
        }
    }
}

