/*
 * Decompiled with CFR 0.152.
 */
package me.av306.keybindsgaloreplus.configmanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import me.av306.keybindsgaloreplus.KeybindsGalorePlus;

public class ConfigManager {
    private final String name;
    private final Path configFileDirectory;
    private final String configFileName;
    private final Class<?> configurableClass;
    private Object configurableClassInstance;
    private File configFile;
    public boolean errorFlag = false;

    public ConfigManager(String name, Path configFilePath, String configFileName, Class<?> configurableClass, Object configurableClassInstance) throws IOException {
        this.name = name;
        this.configFileDirectory = configFilePath;
        this.configFileName = configFileName;
        this.configurableClass = configurableClass;
        this.configurableClassInstance = configurableClassInstance;
        this.checkConfigFileExists();
        this.readConfigFile();
    }

    public void checkConfigFileExists() throws IOException {
        this.configFile = this.configFileDirectory.resolve(this.configFileName).toFile();
        if (!this.configFile.exists()) {
            try (InputStream defaultConfigFileInputStream = this.getClass().getResourceAsStream("/" + this.configFileName);
                 FileOutputStream fos = new FileOutputStream(this.configFile);){
                this.configFile.createNewFile();
                KeybindsGalorePlus.LOGGER.warn("(KBG+ Config Manager) {} config file not found, copying default config file", (Object)this.name);
                defaultConfigFileInputStream.transferTo(fos);
            }
            catch (IOException ioe) {
                KeybindsGalorePlus.LOGGER.error("(KBG+ Config Manager) IOException while copying default config file!");
                ioe.printStackTrace();
                throw ioe;
            }
        }
        KeybindsGalorePlus.LOGGER.info("(KBG+ Config Manager) Config file exists!");
    }

    public void readConfigFile() throws IOException {
        this.errorFlag = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
            for (String line : (String[])reader.lines().toArray(String[]::new)) {
                if (line.trim().startsWith("#") || line.isBlank()) continue;
                String[] entry = line.split("=");
                try {
                    entry[0] = entry[0].trim();
                    entry[1] = entry[1].trim();
                    Field f = this.configurableClass.getDeclaredField(entry[0].toUpperCase(Locale.getDefault()));
                    Class<Serializable> fieldTypeClass = f.getType();
                    if (fieldTypeClass.isAssignableFrom(Short.TYPE)) {
                        f.setShort(this.configurableClassInstance, Short.parseShort(entry[1].replace("0x", ""), 16));
                        continue;
                    }
                    if (fieldTypeClass.isAssignableFrom(Integer.TYPE)) {
                        if (entry[1].startsWith("0x")) {
                            Integer.parseInt(entry[1].replace("0x", ""), 16);
                            continue;
                        }
                        f.setInt(this.configurableClassInstance, Integer.parseInt(entry[1]));
                        continue;
                    }
                    if (fieldTypeClass.isAssignableFrom(Float.TYPE)) {
                        f.setFloat(this.configurableClassInstance, Float.parseFloat(entry[1]));
                        continue;
                    }
                    if (fieldTypeClass.isAssignableFrom(Boolean.TYPE)) {
                        f.setBoolean(this.configurableClassInstance, Boolean.parseBoolean(entry[1]));
                        continue;
                    }
                    if (fieldTypeClass.isAssignableFrom(ArrayList.class)) {
                        ArrayList<Integer> list = new ArrayList<Integer>();
                        for (String e : entry[1].replaceAll("[\\[\\]\\s]+", "").split(",")) {
                            list.add(Integer.parseInt(e));
                        }
                        f.set(this.configurableClassInstance, list);
                        continue;
                    }
                    KeybindsGalorePlus.LOGGER.error("(KBG+ Config Manager) Unrecognised data type for config entry {}", (Object)line);
                }
                catch (NoSuchFieldException nsfe) {
                    KeybindsGalorePlus.LOGGER.error("(KBG+ Config Manager) No matching field found for config entry: {}", (Object)entry[0]);
                    this.errorFlag = true;
                }
                catch (IllegalAccessException illegal) {
                    KeybindsGalorePlus.LOGGER.error("(KBG+ Config Manager) Could not set field involved in: {}", (Object)line);
                    this.errorFlag = true;
                    illegal.printStackTrace();
                }
                catch (Exception e) {
                    KeybindsGalorePlus.LOGGER.error("(KBG+ Config Manager) Malformed config entry: {}", (Object)line);
                    this.errorFlag = true;
                }
            }
        }
        catch (IOException ioe) {
            KeybindsGalorePlus.LOGGER.error("(KBG+ Config Manager) IOException while reading config file: {}", (Object)ioe.getMessage());
            throw ioe;
        }
        KeybindsGalorePlus.LOGGER.info("(KBG+ Config Manager) Finished reading config file!");
    }

    public void printAllConfigs() {
        KeybindsGalorePlus.LOGGER.info("(KBG+ Config Manager) Dumping configs:");
        for (Field f : this.configurableClass.getDeclaredFields()) {
            try {
                KeybindsGalorePlus.LOGGER.info("\t{}: {}", (Object)f.getName(), f.get(this.configurableClassInstance));
            }
            catch (IllegalAccessException | NullPointerException exception) {
                // empty catch block
            }
        }
    }
}

