/*
 * Decompiled with CFR 0.152.
 */
package me.av306.keybindsgaloreplus.customdata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Hashtable;
import me.av306.keybindsgaloreplus.Configurations;
import me.av306.keybindsgaloreplus.KeybindsGalorePlus;
import me.av306.keybindsgaloreplus.customdata.KeybindData;

public class DataManager {
    private final File dataFile;
    public final Hashtable<String, KeybindData> customData = new Hashtable();
    public boolean hasCustomData = true;

    public DataManager(Path dataFilePath, String dataFileName) {
        this.dataFile = dataFilePath.resolve(dataFileName).toFile();
        if (!this.dataFile.exists()) {
            this.hasCustomData = false;
            KeybindsGalorePlus.LOGGER.warn("(KBG+ Custom Data Manager) No custom keybind data file found!");
            return;
        }
        this.readDataFile();
    }

    public void readDataFile() {
        this.hasCustomData = true;
        try (BufferedReader fileReader = new BufferedReader(new FileReader(this.dataFile));){
            String line;
            String currentKeybind = null;
            while ((line = fileReader.readLine()) != null) {
                if (line.isBlank()) continue;
                if (!line.endsWith(":")) {
                    String[] lines = line.trim().split("=");
                    try {
                        lines[1] = lines[1].replaceAll("\"", "");
                        switch (lines[0]) {
                            case "display_name": {
                                this.customData.get((Object)currentKeybind).displayName = lines[1];
                                break;
                            }
                            case "sector_color": {
                                this.customData.get((Object)currentKeybind).sectorColor = Integer.parseInt(lines[1].replace("0x", ""), 16);
                                break;
                            }
                            case "hide_category": {
                                this.customData.get((Object)currentKeybind).hideCategory = Boolean.parseBoolean(lines[1]);
                                break;
                            }
                            default: {
                                KeybindsGalorePlus.LOGGER.info("(KBG+ Custom Data Manager) Unknown custom data field: {}", (Object)lines[0]);
                                break;
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException oobe) {
                        KeybindsGalorePlus.LOGGER.warn("(KBG+ Custom Data Manager) Skipped invalid data line: {}", (Object)line);
                    }
                    continue;
                }
                currentKeybind = line.replaceAll("[\":]+", "").trim();
                this.customData.put(currentKeybind, new KeybindData());
                KeybindsGalorePlus.LOGGER.info("(KBG+ Custom Data Manager) Reading custom data for keybind: {}", (Object)currentKeybind);
            }
            KeybindsGalorePlus.LOGGER.info("(KBG+ Custom Data Manager) Custom keybind data file read successfully!");
        }
        catch (IOException ioe) {
            this.hasCustomData = false;
            KeybindsGalorePlus.LOGGER.warn("(KBG+ Custom Data Manager) IOException while reading custom data: {}", (Object)ioe.getMessage());
        }
        if (Configurations.DEBUG) {
            KeybindsGalorePlus.LOGGER.info("(KBG+ Custom Data Manager) Custom data present: {}", (Object)this.hasCustomData);
            this.customData.forEach((keyId, data) -> {
                for (Field f : data.getClass().getDeclaredFields()) {
                    try {
                        KeybindsGalorePlus.LOGGER.info("\t[{} -> {}]: {}", new Object[]{keyId, f.getName(), f.get(data)});
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

