/*
 * Decompiled with CFR 0.152.
 */
package me.av306.keybindsgaloreplus.render;

import me.av306.keybindsgaloreplus.Configurations;
import me.av306.keybindsgaloreplus.CustomRenderLayers;
import me.av306.keybindsgaloreplus.render.KeybindSelectorElementRenderState;
import net.minecraft.class_11239;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class KeybindSelectorElementRenderer
extends class_11239<KeybindSelectorElementRenderState> {
    public KeybindSelectorElementRenderer(class_4597.class_4598 vertexConsumerProvider) {
        super(vertexConsumerProvider);
    }

    protected void render(KeybindSelectorElementRenderState state, class_4587 matrices) {
        class_4588 buffer = this.field_59933.getBuffer((class_1921)CustomRenderLayers.GUI_TRIANGLE_STRIP);
        int centreX = (state.comp_4124() - state.comp_4122()) / 2;
        int centreY = (state.comp_4125() - state.comp_4123()) / 2;
        int numberOfSectors = state.numberOfSectors();
        float sectorAngle = state.sectorAngle();
        int selectedSectorIndex = state.selectedSectorIndex();
        float delta = state.tickDelta();
        float maxRadius = Math.min((float)centreX * Configurations.PIE_MENU_SCALE - (float)Configurations.PIE_MENU_MARGIN, (float)centreY * Configurations.PIE_MENU_SCALE - (float)Configurations.PIE_MENU_MARGIN);
        float cancelZoneRadius = maxRadius * Configurations.CANCEL_ZONE_SCALE;
        float currentAngle = 0.0f;
        int numberOfVerticesPerSector = Configurations.CIRCLE_VERTICES / numberOfSectors;
        if (numberOfVerticesPerSector < 1) {
            numberOfVerticesPerSector = 1;
        }
        for (int currentDrawnSectorIndex = 0; currentDrawnSectorIndex < numberOfSectors; ++currentDrawnSectorIndex) {
            float outerRadius = KeybindSelectorElementRenderer.calculateRadius(state.ticksInScreen(), delta, numberOfSectors, currentDrawnSectorIndex, state.selectedSectorIndex(), maxRadius);
            float innerRadius = cancelZoneRadius;
            int innerColor = Configurations.PIE_MENU_COLOR;
            int outerColor = Configurations.PIE_MENU_COLOR;
            if (currentDrawnSectorIndex % 2 == 0) {
                innerColor = outerColor += Configurations.PIE_MENU_COLOR_LIGHTEN_FACTOR;
            }
            if (selectedSectorIndex == currentDrawnSectorIndex) {
                innerRadius *= Configurations.EXPANSION_FACTOR_WHEN_SELECTED;
                int n = outerColor = state.mouseDown() ? Configurations.PIE_MENU_HIGHLIGHT_COLOR : Configurations.PIE_MENU_SELECT_COLOR;
            }
            if (!Configurations.SECTOR_GRADATION) {
                innerColor = outerColor;
            }
            this.writeSectorVertices(buffer, centreX, centreY, currentAngle, sectorAngle, numberOfVerticesPerSector, innerRadius, outerRadius, innerColor, outerColor);
            currentAngle += sectorAngle;
        }
    }

    private void writeSectorVertices(class_4588 buf, int centreX, int centreY, float startAngle, float sectorAngle, int vertices, float innerRadius, float outerRadius, int innerColor, int outerColor) {
        for (int i = 0; i <= vertices; ++i) {
            float angle = startAngle + (float)i / (float)vertices * sectorAngle;
            buf.method_22912((float)centreX + class_3532.method_15362((float)angle) * innerRadius, (float)centreY + class_3532.method_15374((float)angle) * innerRadius, 0.0f);
            buf.method_1336(innerColor >> 16 & 0xFF, innerColor >> 8 & 0xFF, innerColor & 0xFF, (int)Configurations.PIE_MENU_ALPHA);
            buf.method_22912((float)centreX + class_3532.method_15362((float)angle) * outerRadius, (float)centreY + class_3532.method_15374((float)angle) * outerRadius, 0.0f);
            buf.method_1336(outerColor >> 16 & 0xFF, outerColor >> 8 & 0xFF, outerColor & 0xFF, (int)Configurations.PIE_MENU_ALPHA);
        }
    }

    public static float calculateRadius(int ticksInScreen, float delta, int numberOfSectors, int sectorIndex, int selectedSectorIndex, float maxRadius) {
        float radius;
        float f = radius = Configurations.ANIMATE_PIE_MENU ? Math.max(0.0f, Math.min(((float)ticksInScreen + delta - (float)sectorIndex * 6.0f / (float)numberOfSectors) * 40.0f, maxRadius)) : maxRadius;
        if (selectedSectorIndex == sectorIndex) {
            radius *= Configurations.EXPANSION_FACTOR_WHEN_SELECTED;
        }
        return radius;
    }

    protected String method_70906() {
        return "KeybindsGalorePlus Keybind Selector Renderer";
    }

    public Class<KeybindSelectorElementRenderState> method_70903() {
        return KeybindSelectorElementRenderState.class;
    }
}

