/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs;

import fr.raconteur.chatlogs.config.ChatLogsConfig;
import fr.raconteur.chatlogs.database.SessionDatabase;
import fr.raconteur.chatlogs.session.CrashRecovery;
import net.fabricmc.api.ModInitializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChatLogsMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"chatlogs");
    public static final ThreadLocal<Boolean> PERMISSIVE_EVENTS = ThreadLocal.withInitial(() -> false);

    public void onInitialize() {
        LOGGER.info("Initializing Chat Logs mod...");
        try {
            ChatLogsConfig.getInstance();
            LOGGER.info("Chat logs configuration loaded successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize chat logs configuration", (Throwable)e);
            throw new RuntimeException("Critical error: Unable to initialize configuration", e);
        }
        try {
            SessionDatabase.getInstance();
            LOGGER.info("SQLite session database initialized successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize SQLite session database", (Throwable)e);
            throw new RuntimeException("Critical error: Unable to initialize session database", e);
        }
        try {
            CrashRecovery.performRecovery();
        }
        catch (Exception e) {
            LOGGER.error("Failed to perform crash recovery", (Throwable)e);
        }
        LOGGER.info("Chat Logs mod initialized successfully");
    }
}

