/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.config;

import fr.raconteur.chatlogs.ChatLogsMod;
import fr.raconteur.chatlogs.backup.config.Option;
import fr.raconteur.chatlogs.backup.config.OptionType;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.function.Function;
import net.minecraft.class_2561;

public final class Options {
    private static final File OPTION_FILE = new File("chatlogs.prop");
    private static final Properties OPTION_SET;
    @Option(type=OptionType.INTEGER, defaultValue="65535")
    public static int visibleLineCount;
    @Option(type=OptionType.INTEGER, defaultValue="100000")
    public static int autoSaveIntervalInMs;
    @Option(type=OptionType.BOOLEAN, defaultValue="true")
    public static boolean realtimeChatlogSaving;
    @Option(type=OptionType.BOOLEAN, defaultValue="true")
    public static boolean allowCorruptedChatlogs;
    @Option(type=OptionType.BOOLEAN, defaultValue="false")
    public static boolean newSessionPerMcLaunch;
    @Option(type=OptionType.BOOLEAN, defaultValue="true")
    public static boolean gameSessionIndicator;
    @Option(type=OptionType.BOOLEAN, defaultValue="true")
    public static boolean sessionListPaging;
    @Option(type=OptionType.INTEGER, defaultValue="50")
    public static int sessionsPerPage;
    @Option(type=OptionType.BOOLEAN, defaultValue="true")
    public static boolean messageFinderFilteringMode;

    private Options() {
    }

    public static void save() {
        try (FileWriter fw = new FileWriter(OPTION_FILE);){
            OPTION_SET.store(fw, "Options For Chat Logs");
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.error("Failed to save options!");
            e.printStackTrace();
        }
    }

    public static void set(String name, String value) {
        OPTION_SET.setProperty(name, value);
        try {
            Field f = Options.class.getField(name);
            Option o = f.getAnnotation(Option.class);
            f.set(null, o.type().parser.apply(value));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Options.save();
    }

    public static class_2561 getToolTip(String option) {
        return I18N.translateAsText("opt." + option + ".desc");
    }

    static {
        visibleLineCount = 65535;
        autoSaveIntervalInMs = 100000;
        realtimeChatlogSaving = true;
        allowCorruptedChatlogs = true;
        newSessionPerMcLaunch = false;
        gameSessionIndicator = true;
        sessionListPaging = true;
        sessionsPerPage = 50;
        messageFinderFilteringMode = true;
        Properties prop = new Properties();
        if (OPTION_FILE.exists()) {
            try (FileReader fr = new FileReader(OPTION_FILE);){
                prop.load(fr);
            }
            catch (IOException e) {
                ChatLogsMod.LOGGER.error("Failed to load options!");
                e.printStackTrace();
            }
        }
        for (Field f : Options.class.getDeclaredFields()) {
            Option o = f.getAnnotation(Option.class);
            if (o == null) continue;
            prop.computeIfAbsent(f.getName(), (Function<? super Object, ?>)((Function<Object, Object>)n -> o.defaultValue()));
            try {
                f.set(null, o.type().parser.apply(prop.getProperty(f.getName())));
            }
            catch (Exception e) {
                ChatLogsMod.LOGGER.error("Option {} has incorrect value {}!", (Object)f.getName(), (Object)prop.getProperty(f.getName()));
                e.printStackTrace();
                try {
                    f.set(null, o.type().parser.apply(o.defaultValue()));
                }
                catch (Exception e1) {
                    throw new RuntimeException("Incorrect default value for " + f.getName(), e1);
                }
            }
        }
        OPTION_SET = prop;
        Options.save();
    }
}

