/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.export;

import com.google.common.collect.ImmutableList;
import fr.raconteur.chatlogs.backup.export.ExportConfig;
import fr.raconteur.chatlogs.backup.export.HtmlFormatAdapter;
import fr.raconteur.chatlogs.backup.export.TxtFormatAdapter;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import java.io.Writer;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FormatAdapter {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final ImmutableList<Factory<? extends FormatAdapter>> FORMAT_FACTORIES = ImmutableList.builder().add(HtmlFormatAdapter.FACTORY).add(TxtFormatAdapter.FACTORY).build();
    protected final Writer directOut;
    protected final Session.Summary sessionMeta;
    protected final Session session;
    protected final ExportConfig config;

    public FormatAdapter(Writer directOut, Session.Summary sessionMeta, Session session, ExportConfig config) {
        this.directOut = directOut;
        this.sessionMeta = sessionMeta;
        this.session = session;
        this.config = config;
    }

    public abstract void write() throws Exception;

    public static abstract class Factory<T extends FormatAdapter> {
        private final String id;

        public Factory(String id) {
            this.id = id;
        }

        public abstract T create(Writer var1, Session.Summary var2, Session var3, ExportConfig var4);

        public final String getId() {
            return this.id;
        }

        public final String getExtension() {
            return this.id;
        }

        public final String getDescription() {
            return I18N.translate("gui.export." + this.getId());
        }

        public final class_2561 getDisplayedText() {
            return class_2561.method_43470((String)String.format("%s (.%s)", this.getDescription(), this.getId()));
        }
    }
}

