/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.export;

import fr.raconteur.chatlogs.backup.export.ExportConfig;
import fr.raconteur.chatlogs.backup.export.FormatAdapter;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import fr.raconteur.chatlogs.backup.util.TextEventContentExtractor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringEscapeUtils;

final class HtmlFormatAdapter
extends FormatAdapter {
    public static final FormatAdapter.Factory<HtmlFormatAdapter> FACTORY = new FormatAdapter.Factory<HtmlFormatAdapter>("html"){

        @Override
        public HtmlFormatAdapter create(Writer out, Session.Summary summary, Session session, ExportConfig config) {
            return new HtmlFormatAdapter(out, summary, session, config);
        }
    };
    List<String> spanIds;
    private int spanCount = 0;
    Map<String, class_2568> hoverEventsBySpan;
    Map<String, class_2558> clickEventsBySpan;
    XMLStreamWriter html;

    public HtmlFormatAdapter(Writer out, Session.Summary summary, Session session, ExportConfig config) {
        super(out, summary, session, config);
    }

    @Override
    public void write() throws XMLStreamException, FactoryConfigurationError, IOException {
        this.directOut.append("<!DOCTYPE html>");
        this.html = XMLOutputFactory.newFactory().createXMLStreamWriter(this.directOut);
        this.html.writeStartElement("html");
        this.writeHead();
        this.html.writeStartElement("body");
        this.writeStartingDiv("main_container");
        this.spanIds = new ArrayList<String>();
        this.hoverEventsBySpan = new HashMap<String, class_2568>();
        this.clickEventsBySpan = new HashMap<String, class_2558>();
        this.session.getMessages().forEach(l -> {
            try {
                this.handleLine((Session.Line)l);
            }
            catch (XMLStreamException e) {
                LOGGER.error("Failed to handle message: {}", (Object)l.message);
                e.printStackTrace();
            }
        });
        this.writeFooter();
        this.buildJavaScript();
        this.html.writeEndElement();
        this.html.writeEndElement();
        this.html.writeEndElement();
    }

    private String nextSpanId() {
        String spanId = "t_" + this.spanCount++;
        this.spanIds.add(spanId);
        return spanId;
    }

    void buildJavaScript() throws IOException, XMLStreamException {
        this.html.writeStartElement("script");
        this.html.writeCharacters("\n");
        StringBuilder js = new StringBuilder();
        this.buildEventMap(js);
        js.append(Files.readString(((Path)((ModContainer)FabricLoader.getInstance().getModContainer("chatlogs").get()).getRootPaths().get(0)).resolve("assets/textEventHandler.js")));
        this.directOut.append(js);
        this.html.writeEndElement();
    }

    private void buildEventMap(StringBuilder js) {
        js.append("const hoverEvents = {");
        this.hoverEventsBySpan.forEach((span, e) -> {
            js.append((String)span).append(": {");
            js.append("action: \"");
            js.append(e.method_10892().method_15434());
            js.append("\", ");
            js.append("value: \"");
            HtmlFormatAdapter.serializeHoverEvent(js, e);
            js.append("\"},");
        });
        if (js.codePointAt(js.length() - 1) == 44) {
            js.deleteCharAt(js.length() - 1);
        }
        js.append("}; ");
        js.append("const clickEvents = {");
        this.clickEventsBySpan.forEach((span, e) -> {
            js.append((String)span).append(": {");
            js.append("action: \"");
            js.append(e.method_10845().method_15434());
            js.append("\", ");
            js.append("value: \"");
            HtmlFormatAdapter.serializeClickEvent(js, e);
            js.append("\"},");
        });
        if (js.codePointAt(js.length() - 1) == 44) {
            js.deleteCharAt(js.length() - 1);
        }
        js.append("};");
    }

    private static void serializeHoverEvent(StringBuilder js, class_2568 event) {
        class_2561 content = TextEventContentExtractor.getHoverEventContent(event);
        HtmlFormatAdapter.text2StringIgnoringEvents(js, content);
    }

    private static void serializeClickEvent(StringBuilder js, class_2558 event) {
        String content = TextEventContentExtractor.getClickEventContent(event);
        js.append(StringEscapeUtils.escapeJava((String)content));
    }

    private static void writeStringWithNewLines(String str, XMLStreamWriter html) throws XMLStreamException {
        String[] segs = str.split("\\n");
        for (int i = 0; i < segs.length; ++i) {
            html.writeCharacters(segs[i]);
            if (i >= segs.length - 1) continue;
            html.writeEmptyElement("br");
        }
        if (str.endsWith("\n")) {
            html.writeEmptyElement("br");
        }
    }

    private static void text2StringIgnoringEvents(StringBuilder buf, class_2561 t) {
        XMLStreamWriter html;
        StringWriter out = new StringWriter();
        try {
            html = XMLOutputFactory.newFactory().createXMLStreamWriter(out);
        }
        catch (FactoryConfigurationError | XMLStreamException e1) {
            e1.printStackTrace();
            buf.append("Error converting text to string!");
            return;
        }
        t.method_27658((style, str) -> {
            int depth = 0;
            try {
                if (style.method_10984()) {
                    html.writeStartElement("b");
                    ++depth;
                }
                if (style.method_10966()) {
                    html.writeStartElement("i");
                    ++depth;
                }
                if (style.method_10986()) {
                    html.writeStartElement("del");
                    ++depth;
                }
                if (style.method_10973() != null) {
                    html.writeStartElement("span");
                    html.writeAttribute("style", String.format("color: #%6x", style.method_10973().method_27716() & 0xFFFFFF));
                    ++depth;
                }
                HtmlFormatAdapter.writeStringWithNewLines(str, html);
                for (int i = 0; i < depth; ++i) {
                    html.writeEndElement();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.error("Failed to export text: {}", (Object)t);
                e.printStackTrace();
            }
            return Optional.empty();
        }, class_2583.field_24360);
        buf.append(StringEscapeUtils.escapeJava((String)out.getBuffer().toString()));
    }

    void handleLine(Session.Line l) throws XMLStreamException {
        this.writeStartingDiv("message");
        this.writeStartingDiv("msg_marker");
        this.html.writeAttribute("style", String.format("background: #%6x", l.getMarkColor() & 0xFFFFFF));
        this.html.writeAttribute("data-sent-time", Long.toString(l.time));
        this.html.writeEndElement();
        this.writeStartingDiv("msg_text");
        l.message.method_27658((style, str) -> {
            int depth = 0;
            try {
                if (style.method_10984()) {
                    this.html.writeStartElement("b");
                    ++depth;
                }
                if (style.method_10966()) {
                    this.html.writeStartElement("i");
                    ++depth;
                }
                if (style.method_10986()) {
                    this.html.writeStartElement("del");
                    ++depth;
                }
                class_2558 ce = style.method_10970();
                class_2568 he = style.method_10969();
                String spanId = this.nextSpanId();
                this.writeStartingSpan(spanId);
                if (style.method_10973() != null) {
                    this.html.writeAttribute("style", String.format("color: #%6x", style.method_10973().method_27716() & 0xFFFFFF));
                }
                ++depth;
                if (ce != null) {
                    this.clickEventsBySpan.put(spanId, ce);
                }
                if (he != null) {
                    this.hoverEventsBySpan.put(spanId, he);
                }
                HtmlFormatAdapter.writeStringWithNewLines(str, this.html);
                for (int i = 0; i < depth; ++i) {
                    this.html.writeEndElement();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.error("Failed to export text: {}", (Object)l.message);
                e.printStackTrace();
            }
            return Optional.empty();
        }, class_2583.field_24360);
        this.html.writeEndElement();
        this.html.writeEndElement();
    }

    private void writeHead() throws XMLStreamException, IOException {
        this.html.writeStartElement("head");
        this.html.writeStartElement("title");
        this.html.writeCharacters(I18N.translate("export.this.html.title", this.sessionMeta.saveName, this.sessionMeta.size, this.sessionMeta.getFormattedStartTime()));
        this.html.writeEndElement();
        this.writeStyleSheet();
        this.html.writeEmptyElement("meta");
        this.html.writeAttribute("charset", "utf-8");
        this.html.writeEndElement();
    }

    private void writeFooter() throws XMLStreamException, IOException {
        this.writeStartingDiv("footer");
        this.html.writeCharacters(I18N.translate("export.this.html.footer1", LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS)));
        this.html.writeStartElement("a");
        this.html.writeAttribute("href", "https://modrinth.com/mod/permanent-chatlogs");
        ModMetadata modMeta = ((ModContainer)FabricLoader.getInstance().getModContainer("chatlogs").get()).getMetadata();
        this.html.writeCharacters(modMeta.getName() + " " + String.valueOf(modMeta.getVersion()));
        this.html.writeEndElement();
        this.html.writeEmptyElement("br");
        this.html.writeCharacters(I18N.translate("export.this.html.footer2", class_310.method_1551().method_53462().getName()));
        this.html.writeEndElement();
    }

    void writeStartingDiv(String clazz) throws XMLStreamException {
        this.html.writeStartElement("div");
        this.html.writeAttribute("class", clazz);
    }

    private void writeStartingSpan(String id) throws XMLStreamException {
        this.html.writeStartElement("span");
        this.html.writeAttribute("id", id);
    }

    private void writeStyleSheet() throws XMLStreamException, IOException {
        this.html.writeStartElement("style");
        this.html.writeCharacters(Files.readString(((Path)((ModContainer)FabricLoader.getInstance().getModContainer("chatlogs").get()).getRootPaths().get(0)).resolve("assets/defaultStyle.css")));
        this.html.writeEndElement();
    }
}

