/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.export;

import fr.raconteur.chatlogs.backup.export.ExportConfig;
import fr.raconteur.chatlogs.backup.export.FormatAdapter;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

class TxtFormatAdapter
extends FormatAdapter {
    public static final FormatAdapter.Factory<TxtFormatAdapter> FACTORY = new FormatAdapter.Factory<TxtFormatAdapter>("txt"){

        @Override
        public TxtFormatAdapter create(Writer out, Session.Summary summary, Session session, ExportConfig config) {
            return new TxtFormatAdapter(out, summary, session, config);
        }
    };
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public TxtFormatAdapter(Writer out, Session.Summary summary, Session session, ExportConfig config) {
        super(out, summary, session, config);
    }

    @Override
    public void write() {
        PrintWriter pw = new PrintWriter(this.directOut);
        pw.println();
        pw.println(I18N.translate("gui.filter.savename") + ": " + this.sessionMeta.saveName);
        pw.println(I18N.translate("gui.filter.date") + ": " + Instant.ofEpochMilli(this.sessionMeta.startTime).atZone(this.sessionMeta.timeZone.toZoneId()).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        pw.println(I18N.translate("gui.filter.messages") + ": " + this.sessionMeta.size);
        pw.println();
        this.session.getMessages().forEach(l -> {
            if (this.config.includeTimeOfMsgs()) {
                pw.printf("[%s]", TIME_FORMAT.format(Instant.ofEpochMilli(l.time).atZone(this.sessionMeta.timeZone.toZoneId())));
            }
            if (this.config.includeSender()) {
                pw.printf("[%s]", l.sender);
            }
            pw.println(l.message.getString());
        });
    }
}

