/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.gui;

import com.google.common.collect.ImmutableList;
import fr.raconteur.chatlogs.backup.config.Options;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import fr.raconteur.chatlogs.backup.util.TextEventContentExtractor;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_341;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;

public final class ChatLogScreen
extends class_437 {
    private final Session session;
    private final ZoneId timeZone;
    private ChatLogWidget chatlogs;
    private SearchFieldWidget searchField;
    private class_5676<SearchingMode> searchBarModeChooser;
    private final class_437 parent;

    protected ChatLogScreen(Session.Summary metadata, Session session, class_437 parent) {
        super((class_2561)class_2561.method_43470((String)metadata.saveName));
        this.session = session;
        this.timeZone = metadata.timeZone.toZoneId();
        this.parent = parent;
    }

    protected void method_25426() {
        this.field_22789 = (int)((float)this.field_22787.method_22683().method_4480() * 0.8f);
        this.chatlogs = new ChatLogWidget(this.field_22787, this.session);
        this.searchField = new SearchFieldWidget(this, this.field_22793);
        this.method_37063((class_364)this.searchField);
        this.method_37063((class_364)this.chatlogs);
        this.searchBarModeChooser = class_5676.method_32606(SearchingMode::displayedText).method_32624((Object[])SearchingMode.values()).method_32619((Object)SearchingMode.TEXT).method_32617(2, 0, (int)((float)this.field_22787.method_22683().method_4486() * 0.2f) - 4, 20, class_5244.field_39003, (b, v) -> this.chatlogs.search(this.searchField.method_1882()));
        class_4185 extractBtn = class_4185.method_46430((class_2561)I18N.translateAsText("gui.extract"), btn -> {
            List<Session.Line> delims = this.chatlogs.collectDelimiters();
            switch (delims.size()) {
                case 0: {
                    class_370 warning = new class_370(new class_370.class_9037(), I18N.translateAsText("gui.extract.nodelim"), I18N.translateAsText("gui.extract.nodelim.desc"));
                    class_310.method_1551().method_1566().method_1999((class_368)warning);
                    break;
                }
                case 1: {
                    class_410 endChooser = new class_410(before -> {
                        Session chosen = before ? this.session.clip(null, (Session.Line)delims.get(0)) : this.session.clip((Session.Line)delims.get(0), null);
                        this.saveExtractedSession(chosen);
                        this.field_22787.method_1507((class_437)this);
                    }, class_5244.field_39003, I18N.translateAsText("gui.extract.choend"), I18N.translateAsText("gui.extract.before"), I18N.translateAsText("gui.extract.after"));
                    this.field_22787.method_1507((class_437)endChooser);
                    break;
                }
                case 2: {
                    this.saveExtractedSession(this.session.clip(delims.get(0), delims.get(1)));
                    break;
                }
                default: {
                    class_370 warning = new class_370(new class_370.class_9037(), I18N.translateAsText("gui.extract.muldelim"), I18N.translateAsText("gui.extract.muldelim.desc"));
                    class_310.method_1551().method_1566().method_1999((class_368)warning);
                }
            }
        }).method_46434((int)((float)this.field_22787.method_22683().method_4486() * 0.8f) + 2, 0, (int)((float)this.field_22787.method_22683().method_4486() * 0.2f) - 4, 20).method_46431();
        this.method_37063((class_364)this.searchBarModeChooser);
        this.method_37063((class_364)extractBtn);
    }

    void scrollTo(int ordinalInSession) {
        this.chatlogs.scrollTo(ordinalInSession);
    }

    private void saveExtractedSession(Session s) {
        s.save();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.chatlogs.method_25404(keyCode, scanCode, modifiers);
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private final class ChatLogWidget
    extends class_4265<Entry> {
        private final List<Entry> allEntries;
        private ListIterator<Entry> highlightenEntryHead;

        public ChatLogWidget(class_310 client, Session session) {
            int n = ChatLogScreen.this.field_22787.method_22683().method_4486();
            int n2 = ChatLogScreen.this.field_22790 - 40;
            Objects.requireNonNull(client.field_1772);
            super(client, n, n2, 20, 9 + 1);
            this.highlightenEntryHead = null;
            session.getMessages().forEach(l -> {
                boolean[] firstLine = new boolean[]{true};
                class_341.method_1850((class_5348)l.message, (int)(ChatLogScreen.this.field_22787.method_22683().method_4486() - 14), (class_327)ChatLogScreen.this.field_22793).forEach(t -> {
                    this.method_25321((class_350.class_351)new Entry((Session.Line)l, (class_5481)t, l.time, firstLine[0]));
                    firstLine[0] = false;
                });
            });
            this.allEntries = ImmutableList.copyOf((Collection)this.method_25396());
        }

        public List<Session.Line> collectDelimiters() {
            return this.allEntries.stream().filter((? super T e) -> e.isDelimiter).map(e -> e.owner).distinct().collect(Collectors.toList());
        }

        public int method_25322() {
            return ChatLogScreen.this.field_22787.method_22683().method_4486();
        }

        protected int method_65507() {
            return this.method_55442() - 5;
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            this.method_44382(this.method_44387() - (verticalAmount *= (double)this.field_22741 / 2.0 * (class_437.method_25441() ? (double)(class_437.method_25443() ? 160 : 32) : 4.0)));
            return true;
        }

        protected void search(String key) {
            if (key.isEmpty() && !((SearchingMode)((Object)ChatLogScreen.this.searchBarModeChooser.method_32603())).natuallyRestrictive) {
                this.highlightenEntryHead = null;
                this.method_25314(this.allEntries);
                this.method_25395(null);
                return;
            }
            if (Options.messageFinderFilteringMode) {
                this.filter(key);
            } else {
                this.highlightSelected(key);
            }
        }

        private List<Entry> getMatchingMessages(String in) {
            return this.allEntries.stream().filter((? super T e) -> {
                switch (((SearchingMode)((Object)((Object)ChatLogScreen.this.searchBarModeChooser.method_32603()))).ordinal()) {
                    case 0: {
                        return e.lineStr.contains(in);
                    }
                    case 1: {
                        return e.getFormattedTime().contains(in);
                    }
                    case 2: {
                        return true;
                    }
                    case 3: {
                        return e.owner instanceof Session.Event && e.lineStr.contains(in);
                    }
                    case 4: {
                        return e.owner instanceof Session.WorldIndicator && e.lineStr.contains(in);
                    }
                }
                return true;
            }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        }

        private void filter(String in) {
            this.method_25314(this.getMatchingMessages(in));
            this.method_44382(0.0);
        }

        private void highlightSelected(String in) {
            List<Entry> selected = this.getMatchingMessages(in);
            if (selected.isEmpty()) {
                this.highlightenEntryHead = null;
                this.method_25395(null);
                return;
            }
            this.highlightenEntryHead = selected.listIterator();
            this.method_25395((class_364)selected.get(0));
            this.method_25324((class_350.class_351)selected.get(0));
        }

        private static void showNoMoreMatchesToast() {
            class_370 warning = new class_370(new class_370.class_9037(), I18N.translateAsText("gui.search.nomore"), I18N.translateAsText("gui.search.nomore.desc"));
            class_310.method_1551().method_1566().method_1999((class_368)warning);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.highlightenEntryHead == null) {
                return false;
            }
            if (this.highlightenEntryHead != null || keyCode == 292) {
                if (class_437.method_25442()) {
                    if (!this.highlightenEntryHead.hasPrevious()) {
                        ChatLogWidget.showNoMoreMatchesToast();
                        return true;
                    }
                    Entry prev = this.highlightenEntryHead.previous();
                    this.method_25395((class_364)prev);
                    this.method_25324((class_350.class_351)prev);
                } else {
                    if (!this.highlightenEntryHead.hasNext()) {
                        ChatLogWidget.showNoMoreMatchesToast();
                        return true;
                    }
                    Entry next = this.highlightenEntryHead.next();
                    this.method_25395((class_364)next);
                    this.method_25324((class_350.class_351)next);
                }
            }
            return true;
        }

        void scrollTo(int ordinalInSession) {
            Session.Line prev = null;
            int curOrd = -1;
            for (Entry e : this.allEntries) {
                if (e.owner != prev) {
                    prev = e.owner;
                    ++curOrd;
                }
                if (curOrd != ordinalInSession) continue;
                this.method_25324((class_350.class_351)e);
                return;
            }
        }

        private final class Entry
        extends class_4265.class_4266<Entry> {
            protected final Session.Line owner;
            private final class_5481 line;
            private final String lineStr;
            private final long time;
            private final boolean firstLine;
            private boolean isDelimiter = false;

            protected Entry(Session.Line owner, class_5481 t, long time, boolean firstLine) {
                this.owner = owner;
                this.line = t;
                this.time = time;
                this.firstLine = firstLine;
                StringBuilder sb = new StringBuilder();
                t.accept((idx, style, cp) -> {
                    sb.append((char)cp);
                    return true;
                });
                this.lineStr = sb.toString();
            }

            public String getFormattedTime() {
                return this.time == 0L ? I18N.translate("gui.unknowntime") : Instant.ofEpochMilli(this.time).atZone(ChatLogScreen.this.timeZone).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }

            public void method_25343(class_332 ctx, int j, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float var10) {
                class_327 tr = ChatLogScreen.this.field_22793;
                boolean highlight = this.method_25370();
                if (highlight) {
                    ctx.method_49601(x + 4, y - 1, width, 10, -256);
                }
                ctx.method_35720(tr, this.line, x + 4, y, -1);
                if (this.isDelimiter) {
                    int textWidth = ChatLogScreen.this.field_22787.method_22683().method_4486() - 14;
                    ctx.method_51738(x + 4, x + textWidth, y - 1, -65536);
                }
                ctx.method_25294(x + 1, y + (this.firstLine ? 2 : 0), x + 3, y + 10, this.owner.getMarkColor());
                if (hovering) {
                    if (mouseX - x < 4) {
                        String time = this.getFormattedTime();
                        this.renderToolTip(ctx, tr, time, mouseX, mouseY);
                    } else {
                        class_2561 tip = this.getToolTip(mouseX, mouseY);
                        if (tip != null) {
                            this.renderToolTip(ctx, tr, tip, mouseX, mouseY);
                        }
                    }
                }
            }

            private void renderToolTip(class_332 ctx, class_327 tr, String text, int mouseX, int mouseY) {
                ctx.method_51447(tr, class_341.method_1850((class_5348)class_2561.method_43470((String)text), (int)(ChatLogWidget.this.field_22758 / 2), (class_327)tr), mouseX, mouseY);
            }

            private void renderToolTip(class_332 ctx, class_327 tr, class_2561 text, int mouseX, int mouseY) {
                ctx.method_51447(tr, class_341.method_1850((class_5348)text, (int)(ChatLogWidget.this.field_22758 / 2), (class_327)tr), mouseX, mouseY);
            }

            public List<? extends class_364> method_25396() {
                return new ArrayList();
            }

            public List<? extends class_6379> method_37025() {
                return new ArrayList();
            }

            @Nullable
            private class_2561 getToolTip(double mouseX, double mouseY) {
                class_327 tr = ChatLogScreen.this.field_22793;
                double scale = ChatLogScreen.this.field_22787.method_22683().method_4495();
                int pos = (int)Math.floor(mouseX - 4.0 * scale);
                class_2583 style = tr.method_27527().method_30876(this.line, pos);
                if (style != null) {
                    boolean hasHoverText = false;
                    class_2568 he = style.method_10969();
                    if (he != null && !class_437.method_25443()) {
                        hasHoverText = true;
                        return TextEventContentExtractor.getHoverEventContent(he);
                    }
                    class_2558 ce = style.method_10970();
                    if (ce != null && !hasHoverText) {
                        return class_2561.method_43470((String)TextEventContentExtractor.getClickEventContent(ce));
                    }
                }
                return null;
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                class_2561 tip;
                if (class_437.method_25441() && (tip = this.getToolTip(mouseX, mouseY)) != null) {
                    ((ChatLogScreen)ChatLogScreen.this).field_22787.field_1774.method_1455(tip.getString());
                    return true;
                }
                if (class_437.method_25442()) {
                    this.isDelimiter ^= true;
                }
                return false;
            }
        }
    }

    private final class SearchFieldWidget
    extends class_342 {
        public SearchFieldWidget(ChatLogScreen chatLogScreen, class_327 textRenderer) {
            super(textRenderer, (int)((float)chatLogScreen.field_22787.method_22683().method_4486() * 0.2f), 2, (int)((float)chatLogScreen.field_22787.method_22683().method_4486() * 0.6f), 16, I18N.translateAsText("gui.search"));
            this.method_1863(chatLogScreen.chatlogs::search);
        }
    }

    private static enum SearchingMode {
        TEXT(false),
        TIME(false),
        SENDER(false),
        EVENT(true),
        SAVE_INDICATOR(true);

        protected final boolean natuallyRestrictive;

        private SearchingMode(boolean natuallyRestrictive) {
            this.natuallyRestrictive = natuallyRestrictive;
        }

        protected class_2561 displayedText() {
            return I18N.translateAsText("gui.search.mode." + this.name().toLowerCase());
        }
    }
}

