/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.gui;

import fr.raconteur.chatlogs.backup.export.ExportConfig;
import fr.raconteur.chatlogs.backup.export.FormatAdapter;
import fr.raconteur.chatlogs.backup.gui.SessionListScreen;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.Charset;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;

public class ExportSessionScreen
extends class_437 {
    private static final File EXPORT_FOLDER = (File)class_156.method_656(() -> {
        File f = new File("chatlogs/export");
        if (f.isDirectory()) {
            return f;
        }
        if (!f.mkdir()) {
            return null;
        }
        return f;
    });
    private class_342 fileName;
    private class_5676<FormatAdapter.Factory<?>> format;
    private class_5676<Boolean> openAfterExport;
    private final Session.Summary sessionMeta;

    protected ExportSessionScreen(Session.Summary summary) {
        super(I18N.translateAsText("gui.export"));
        this.sessionMeta = summary;
    }

    protected void method_25426() {
        this.fileName = new class_342(this.field_22793, (int)((float)this.field_22789 * 0.3f), (int)((float)this.field_22790 * 0.25f), (int)((float)this.field_22789 * 0.4f), 14, I18N.translateAsText("gui.export.name"));
        this.fileName.method_1852(class_156.method_44893());
        this.format = class_5676.method_32606(FormatAdapter.Factory::getDisplayedText).method_32620(FormatAdapter.FORMAT_FACTORIES).method_32619((Object)((FormatAdapter.Factory)FormatAdapter.FORMAT_FACTORIES.get(0))).method_35723((int)((float)this.field_22789 * 0.3f), (int)((float)this.field_22790 * 0.25f) + 25, (int)((float)this.field_22789 * 0.4f), 20, I18N.translateAsText("gui.export.format"));
        this.openAfterExport = class_5676.method_32607((class_2561)class_5244.field_24336, (class_2561)class_5244.field_24337).method_32619((Object)false).method_35723((int)((float)this.field_22789 * 0.3f), (int)((float)this.field_22790 * 0.25f) + 50, (int)((float)this.field_22789 * 0.4f), 20, I18N.translateAsText("gui.export.open"));
        this.method_37063((class_364)this.fileName);
        this.method_37063((class_364)this.format);
        this.method_37063((class_364)this.openAfterExport);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.export()).method_46434((int)((float)this.field_22789 * 0.3f), (int)((float)this.field_22790 * 0.25f) + 75, (int)((float)this.field_22789 * 0.19f), 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, btn -> this.method_25419()).method_46434((int)((float)this.field_22789 * 0.51f), (int)((float)this.field_22790 * 0.25f) + 75, (int)((float)this.field_22789 * 0.19f), 20).method_46431());
    }

    private void export() {
        if (EXPORT_FOLDER == null) {
            class_370 warning = new class_370(new class_370.class_9037(), I18N.translateAsText("gui.export.nodir"), I18N.translateAsText("gui.export.nodir.desc"));
            class_310.method_1551().method_1566().method_1999((class_368)warning);
            return;
        }
        String extension = ((FormatAdapter.Factory)this.format.method_32603()).getExtension();
        Session session = this.sessionMeta.load();
        if (session == null) {
            class_370 warning = new class_370(new class_370.class_9037(), I18N.translateAsText("gui.sload.failure"), I18N.translateAsText("gui.sload.failure.desc"));
            class_310.method_1551().method_1566().method_1999((class_368)warning);
        }
        File target = new File(EXPORT_FOLDER, this.fileName.method_1882() + "." + extension);
        try (BufferedWriter w = new BufferedWriter(new FileWriter(target, Charset.forName("UTF-8")));){
            Object fmt = ((FormatAdapter.Factory)this.format.method_32603()).create(w, this.sessionMeta, session, new ExportConfig(false, true));
            ((FormatAdapter)fmt).write();
        }
        catch (Exception e) {
            e.printStackTrace();
            class_370 warning = new class_370(new class_370.class_9037(), I18N.translateAsText("gui.export.fail"), I18N.translateAsText("gui.export.fail.desc"));
            class_310.method_1551().method_1566().method_1999((class_368)warning);
            return;
        }
        if (((Boolean)this.openAfterExport.method_32603()).booleanValue()) {
            class_156.method_668().method_672(target);
        }
        this.method_25419();
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)new SessionListScreen());
    }
}

