/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.gui;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.raconteur.chatlogs.backup.gui.FullTextSearchProgressScreen;
import fr.raconteur.chatlogs.backup.gui.SessionListScreen;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.mixin.TextFieldWidgetAccessor;
import fr.raconteur.chatlogs.backup.session.Session;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;

public final class FilterSessionScreen
extends class_437 {
    private final List<Session.Summary> cachedSessions = Session.getSessionSummaries();
    private Predicate<Session.Summary> filterer;
    private class_342 saveName;
    private class_342 date;
    private class_342 size;
    private class_342 seconds;
    private class_342 contents;
    private class_4286 caseSenstive;
    private class_5676<Scope> scopeBtn;

    protected FilterSessionScreen() {
        super(I18N.translateAsText("gui.filter.sessions"));
    }

    public void method_25419() {
        class_2096.class_2100 sizeRange2;
        block13: {
            this.filterer = s -> s.saveName.contains(this.saveName.method_1882());
            try {
                int d;
                int m;
                int y;
                String dateStr = this.date.method_1882();
                int[] dateComps = Arrays.stream(dateStr.split("[^0-9]")).filter(s -> s.matches("^\\d+$")).mapToInt(Integer::parseInt).toArray();
                if (dateComps.length <= 0 || dateComps.length > 3) break block13;
                switch (dateComps.length) {
                    case 1: {
                        y = dateComps[0];
                        m = 0;
                        d = 0;
                        break;
                    }
                    case 2: {
                        y = dateComps[0];
                        m = dateComps[1];
                        d = 0;
                        break;
                    }
                    case 3: {
                        y = dateComps[0];
                        m = dateComps[1];
                        d = dateComps[2];
                        break;
                    }
                    default: {
                        break block13;
                    }
                }
                this.filterer = this.filterer.and(s -> {
                    ZonedDateTime start = ZonedDateTime.ofInstant(Instant.ofEpochMilli(s.startTime), s.timeZone.toZoneId());
                    return !(start.getYear() != y || m != 0 && start.getMonthValue() != m || d != 0 && start.getDayOfMonth() != d);
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            sizeRange2 = class_2096.class_2100.method_9060((StringReader)new StringReader(this.size.method_1882()));
            this.filterer = this.filterer.and(s -> sizeRange2.method_9054((int)s.size));
        }
        catch (CommandSyntaxException sizeRange2) {
            // empty catch block
        }
        try {
            sizeRange2 = class_2096.class_2100.method_9060((StringReader)new StringReader(this.seconds.method_1882()));
            this.filterer = this.filterer.and(s -> sizeRange2.method_9054((int)((s.endTime - s.startTime) / 1000L)));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (!this.contents.method_1882().isEmpty()) {
            this.field_22787.method_1507((class_437)new FullTextSearchProgressScreen(this, this.filterer, this.contents.method_1882(), this.caseSenstive.method_20372()));
        } else {
            this.filterer = this.filterer.and(s -> ((Scope)this.scopeBtn.method_32603()).test((Session.Summary)s));
            this.field_22787.method_1507((class_437)new SessionListScreen(this.filterer));
        }
    }

    public void method_25426() {
        int width = this.field_22787.method_22683().method_4486();
        int height = this.field_22787.method_22683().method_4502();
        this.saveName = new TextFieldWithAutoCompletionWidget(this.field_22793, (int)((float)width * 0.35f), (int)((float)height * 0.25f), (int)((float)width * 0.4f), 14, I18N.translateAsText("gui.filter.savename"));
        this.saveName.method_1863(in -> this.saveName.method_1887((String)this.cachedSessions.stream().map(s -> s.saveName).filter(n -> n.startsWith(this.saveName.method_1882())).collect(Object2IntOpenHashMap::new, (m, s) -> m.put(s, 0), (m1, m2) -> m1.putAll((Map)m2)).object2IntEntrySet().stream().max(Comparator.comparing(Object2IntMap.Entry::getIntValue)).map(Map.Entry::getKey).filter(n -> n.length() > this.saveName.method_1882().length()).map(n -> n.substring(this.saveName.method_1882().length())).orElse(null)));
        this.date = new class_342(this.field_22793, (int)((float)width * 0.35f), (int)((float)height * 0.25f) + 18, (int)((float)width * 0.4f), 14, I18N.translateAsText("gui.filter.date"));
        this.date.method_47404((class_2561)class_2561.method_43470((String)"YYYY-MM-DD").method_27692(class_124.field_1080));
        this.size = new class_342(this.field_22793, (int)((float)width * 0.35f), (int)((float)height * 0.25f) + 36, (int)((float)width * 0.4f), 14, I18N.translateAsText("gui.filter.messages"));
        this.seconds = new class_342(this.field_22793, (int)((float)width * 0.35f), (int)((float)height * 0.25f) + 54, (int)((float)width * 0.4f), 14, I18N.translateAsText("gui.filter.seconds"));
        this.contents = new class_342(this.field_22793, (int)((float)width * 0.35f), (int)((float)height * 0.25f) + 72, (int)((float)width * 0.4f), 14, I18N.translateAsText("gui.filter.fulltext"));
        this.caseSenstive = class_4286.method_54787((class_2561)class_2561.method_43473(), (class_327)this.field_22793).method_54794(false).method_54789((int)((float)width * 0.75f) - 18, (int)((float)height * 0.25f) + 90).method_54788();
        this.scopeBtn = class_5676.method_32606(Scope::getText).method_32624((Object[])Scope.values()).method_32619((Object)Scope.ALL).method_35723((int)((float)width * 0.35f), (int)((float)height * 0.25f) + 108, (int)((float)width * 0.4f), 20, (class_2561)class_2561.method_43471((String)"advMode.type"));
        this.method_37063((class_364)this.saveName);
        this.method_37063((class_364)this.date);
        this.method_37063((class_364)this.size);
        this.method_37063((class_364)this.seconds);
        this.method_37063((class_364)this.contents);
        this.method_37063((class_364)this.caseSenstive);
        this.method_37063((class_364)this.scopeBtn);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.method_25419()).method_46434(width / 2 - 40, (int)((float)height * 0.25f) + 132, 80, 20).method_46431());
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        int width = this.field_22787.method_22683().method_4486();
        int height = this.field_22787.method_22683().method_4502();
        ctx.method_27534(this.field_22793, I18N.translateAsText("gui.filter.savename"), (int)((float)width * 0.27f), (int)((float)height * 0.25f) + 2, -1);
        ctx.method_27534(this.field_22793, I18N.translateAsText("gui.filter.date"), (int)((float)width * 0.27f), (int)((float)height * 0.25f) + 20, -1);
        ctx.method_27534(this.field_22793, I18N.translateAsText("gui.filter.messages"), (int)((float)width * 0.27f), (int)((float)height * 0.25f) + 38, -1);
        ctx.method_27534(this.field_22793, I18N.translateAsText("gui.filter.seconds"), (int)((float)width * 0.27f), (int)((float)height * 0.25f) + 56, -1);
        ctx.method_27534(this.field_22793, I18N.translateAsText("gui.filter.fulltext"), (int)((float)width * 0.27f), (int)((float)height * 0.25f) + 74, -1);
        ctx.method_27534(this.field_22793, I18N.translateAsText("gui.filter.case"), (int)((float)width * 0.27f), (int)((float)height * 0.25f) + 92, -1);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"advMode.type"), (int)((float)width * 0.27f), (int)((float)height * 0.25f) + 113, -1);
        this.saveName.method_25394(ctx, mouseX, mouseY, (float)height);
        this.date.method_25394(ctx, mouseX, mouseY, (float)height);
        this.size.method_25394(ctx, mouseX, mouseY, (float)height);
        this.seconds.method_25394(ctx, mouseX, mouseY, (float)height);
        this.contents.method_25394(ctx, mouseY, width, (float)height);
        this.caseSenstive.method_25394(ctx, mouseX, mouseY, delta);
        this.scopeBtn.method_25394(ctx, mouseX, mouseY, delta);
    }

    private static class TextFieldWithAutoCompletionWidget
    extends class_342 {
        public TextFieldWithAutoCompletionWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
            super(textRenderer, x, y, width, height, text);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 258 && ((TextFieldWidgetAccessor)((Object)this)).getSuggestion() != null) {
                this.method_1852(this.method_1882().concat(((TextFieldWidgetAccessor)((Object)this)).getSuggestion()));
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
    }

    private static enum Scope implements Predicate<Session.Summary>
    {
        SINGLE_PLAYER((class_2561)class_2561.method_43471((String)"menu.singleplayer")){

            @Override
            public boolean test(Session.Summary s) {
                return !s.multiplayer;
            }
        }
        ,
        MULTI_PLAYER((class_2561)class_2561.method_43471((String)"menu.multiplayer")){

            @Override
            public boolean test(Session.Summary s) {
                return s.multiplayer;
            }
        }
        ,
        ALL((class_2561)class_2561.method_43471((String)"gui.all")){

            @Override
            public boolean test(Session.Summary s) {
                return true;
            }
        };

        private final class_2561 text;

        private Scope(class_2561 text) {
            this.text = text;
        }

        private final class_2561 getText() {
            return this.text;
        }

        @Override
        public abstract boolean test(Session.Summary var1);
    }
}

