/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.gui;

import fr.raconteur.chatlogs.backup.gui.FullTextSearchResultScreen;
import fr.raconteur.chatlogs.backup.gui.SessionListScreen;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_410;
import net.minecraft.class_437;

public class FullTextSearchProgressScreen
extends class_437 {
    private final class_437 parent;
    private final Predicate<Session.Summary> metadataCriteria;
    private final String msgKeyword;
    private final boolean caseSensitive;
    private final int total = Session.getSessionSummaries().size();
    private final AtomicInteger doneCount = new AtomicInteger();
    private final ConcurrentHashMap<Session.Summary, List<class_3545<Integer, Session.Line>>> results = new ConcurrentHashMap();

    protected FullTextSearchProgressScreen(class_437 parent, Predicate<Session.Summary> criteria, String msgKeyword, boolean caseSensitive) {
        super(I18N.translateAsText("gui.filter.progress"));
        this.parent = parent;
        this.metadataCriteria = criteria;
        this.msgKeyword = msgKeyword;
        this.caseSensitive = caseSensitive;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25426() {
        super.method_25426();
        this.doWork();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_25300(this.field_22793, I18N.translate("gui.filter.progress"), this.field_22789 / 2, (int)((double)this.field_22790 * 0.4), -1);
        this.drawProgressBar(ctx, (int)((double)this.field_22790 * 0.4) + 15, this.doneCount.get(), this.total);
        if (this.doneCount.get() == this.total) {
            this.field_22787.method_1507((class_437)new class_410(this::showSearchResults, I18N.translateAsText("gui.filter.showmode"), I18N.translateAsText("gui.filter.showmode.desc"), I18N.translateAsText("gui.filter.showmode.message"), I18N.translateAsText("gui.filter.showmode.session")));
        }
    }

    private void drawProgressBar(class_332 ctx, int y, int done, int total) {
        int barWidth = (int)((double)this.field_22789 * 0.6);
        int doneWidth = barWidth * done / total;
        int x = (this.field_22789 - barWidth) / 2;
        ctx.method_25294(x - 1, y - 1, x + barWidth + 1, y + 17, -8421505);
        ctx.method_25294(x, y, x + doneWidth, y + 16, -16711936);
        ctx.method_25300(this.field_22793, String.format("%d / %d", done, total), this.field_22789 / 2, y + 20, -1);
    }

    private void showSearchResults(boolean showMessage) {
        if (showMessage) {
            this.field_22787.method_1507((class_437)new FullTextSearchResultScreen(this.results));
        } else {
            this.field_22787.method_1507((class_437)new SessionListScreen(this.results::containsKey));
        }
    }

    private void doWork() {
        Session.getSessionSummaries().stream().sorted((s0, s1) -> (int)(s1.size - s0.size)).forEach(s -> {
            int[] currentOrd = new int[]{0};
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    if (!this.metadataCriteria.test((Session.Summary)s)) {
                        this.doneCount.incrementAndGet();
                        return;
                    }
                    Session session = s.load();
                    if (session == null) {
                        this.doneCount.incrementAndGet();
                        return;
                    }
                    if (this.caseSensitive) {
                        String key = this.msgKeyword;
                        for (Session.Line l : session.getMessages()) {
                            if (!l.message.getString().contains(key)) continue;
                            class_3545 item = new class_3545((Object)currentOrd[0], (Object)l);
                            this.results.computeIfAbsent((Session.Summary)s, unused -> new ArrayList()).add(item);
                        }
                    } else {
                        String keyUpper = this.msgKeyword.toUpperCase();
                        for (Session.Line l : session.getMessages()) {
                            if (l.message.getString().toUpperCase().contains(keyUpper)) {
                                class_3545 item = new class_3545((Object)currentOrd[0], (Object)l);
                                this.results.computeIfAbsent((Session.Summary)s, unused -> new ArrayList()).add(item);
                            }
                            currentOrd[0] = currentOrd[0] + 1;
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    this.doneCount.incrementAndGet();
                }
            });
        });
    }
}

