/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.gui;

import fr.raconteur.chatlogs.backup.gui.GuiUtils;
import fr.raconteur.chatlogs.backup.gui.SessionListScreen;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import fr.raconteur.chatlogs.backup.util.TextEventContentExtractor;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_341;
import net.minecraft.class_350;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;

public class FullTextSearchResultScreen
extends class_437 {
    private final ConcurrentHashMap<Session.Summary, List<class_3545<Integer, Session.Line>>> results;
    private SessionList sessions;
    private MessageList messages;

    protected FullTextSearchResultScreen(ConcurrentHashMap<Session.Summary, List<class_3545<Integer, Session.Line>>> results) {
        super(I18N.translateAsText("gui.filter.result"));
        this.results = results;
    }

    public void method_25426() {
        this.sessions = new SessionList(this.field_22787, this.results.keySet());
        this.method_37063((class_364)this.sessions);
        this.messages = new MessageList(this.field_22787);
        this.method_37063((class_364)this.messages);
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)new SessionListScreen());
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, I18N.translateAsText("gui.filter.result"), this.field_22789 / 2, 5, -1);
    }

    private class SessionList
    extends class_4280<Entry> {
        public SessionList(class_310 mc, Set<Session.Summary> sessions) {
            super(mc, (int)((double)FullTextSearchResultScreen.this.field_22789 * 0.38), FullTextSearchResultScreen.this.field_22790 - 30, 20, 32);
            sessions.stream().sorted((s1, s2) -> (int)(s2.startTime - s1.startTime)).map(x$0 -> new Entry((Session.Summary)x$0)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            this.method_46421(this.method_25342());
        }

        public int method_25342() {
            return (int)((double)FullTextSearchResultScreen.this.field_22789 * 0.12 - 10.0);
        }

        public int method_25322() {
            return this.field_22758;
        }

        public int method_65507() {
            return FullTextSearchResultScreen.this.field_22789 / 2 - 10;
        }

        private class Entry
        extends class_4280.class_4281<Entry> {
            protected final Session.Summary summary;
            private final class_2561 saveName;
            private final class_2561 start;
            private final class_2561 sizeAndTimeLength;
            private long lastClick = 0L;

            public Entry(Session.Summary info) {
                this.summary = info;
                this.saveName = class_2561.method_43470((String)info.saveName);
                this.start = class_2561.method_43470((String)info.getFormattedStartTime()).method_27692(class_124.field_1080);
                long delta = (long)Math.floor((info.endTime - info.startTime) / 1000L);
                this.sizeAndTimeLength = class_2561.method_43470((String)String.format(I18N.translate("gui.sizeandtime"), (int)Math.floor(delta / 3600L), (int)Math.floor(delta % 3600L / 60L), delta % 60L, info.size)).method_27692(class_124.field_1080);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                FullTextSearchResultScreen.this.messages.setSession(this.summary, FullTextSearchResultScreen.this.results.get(this.summary));
                if (this.method_25370() && class_156.method_658() - this.lastClick < 1000L) {
                    GuiUtils.loadSession(FullTextSearchResultScreen.this.field_22787, this.summary, FullTextSearchResultScreen.this);
                    return true;
                }
                SessionList.this.method_25395((class_364)this);
                this.lastClick = class_156.method_658();
                return true;
            }

            public class_2561 method_37006() {
                return this.saveName;
            }

            public void method_25343(class_332 ctx, int i, int y, int x, int width, int height, int var7, int var8, boolean var9, float var10) {
                class_327 tr = FullTextSearchResultScreen.this.field_22793;
                ctx.method_51439(tr, this.saveName, x, y, -1, false);
                ctx.method_51439(tr, this.start, x, y + 10, -1, false);
                ctx.method_51439(tr, this.sizeAndTimeLength, x, y + 20, -1, false);
            }
        }
    }

    private class MessageList
    extends class_4265<Entry> {
        private Session.Summary currentSessionSummary;

        public MessageList(class_310 mc) {
            int n = (int)((double)FullTextSearchResultScreen.this.field_22789 * 0.38);
            int n2 = FullTextSearchResultScreen.this.field_22790 - 30;
            Objects.requireNonNull(mc.field_1772);
            super(mc, n, n2, 20, 9 + 1);
            this.method_46421(this.method_25342());
        }

        public int method_25342() {
            return (int)((double)FullTextSearchResultScreen.this.field_22789 * 0.5 + 4.0);
        }

        public int method_25322() {
            return this.field_22758;
        }

        public int method_65507() {
            return (int)((double)FullTextSearchResultScreen.this.field_22789 * 0.88);
        }

        public void setSession(Session.Summary summary, List<class_3545<Integer, Session.Line>> lines) {
            this.currentSessionSummary = summary;
            this.method_25339();
            class_5481 title = I18N.translateAsText("gui.filter.matchcnt", lines.size()).method_30937();
            this.method_25321((class_350.class_351)new Entry(title, null, -1));
            for (class_3545<Integer, Session.Line> e : lines) {
                this.method_25321((class_350.class_351)new Entry(class_2561.method_43473().method_30937(), null, -1));
                class_341.method_1850((class_5348)((Session.Line)e.method_15441()).message, (int)(this.field_22758 - 10), (class_327)FullTextSearchResultScreen.this.field_22793).forEach(t -> this.method_25321((class_350.class_351)new Entry((class_5481)t, (Session.Line)e.method_15441(), (Integer)e.method_15442())));
            }
        }

        private class Entry
        extends class_4265.class_4266<Entry> {
            private final class_5481 text;
            private final Session.Line owner;
            private final int ordinalInSession;
            private long lastClick = 0L;

            public Entry(class_5481 text, Session.Line owner, int ord) {
                this.text = text;
                this.owner = owner;
                this.ordinalInSession = ord;
            }

            public String getFormattedTime() {
                return this.owner.time == 0L ? I18N.translate("gui.unknowntime") : Instant.ofEpochMilli(this.owner.time).atZone(MessageList.this.currentSessionSummary.timeZone.toZoneId()).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }

            public void method_25343(class_332 ctx, int i, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float var10) {
                class_327 tr = FullTextSearchResultScreen.this.field_22793;
                ctx.method_35720(tr, this.text, x + 4, y, -1);
                ctx.method_25294(x + 1, y, x + 3, y + 10, this.owner == null ? 0 : this.owner.getMarkColor());
                if (hovering) {
                    if (this.owner != null && mouseX - x < 4) {
                        String time = this.getFormattedTime();
                        this.renderToolTip(ctx, tr, time, mouseX, mouseY);
                    } else {
                        class_2561 tip = this.getToolTip(mouseX, mouseY);
                        if (tip != null) {
                            this.renderToolTip(ctx, tr, tip, mouseX, mouseY);
                        }
                    }
                }
            }

            private void renderToolTip(class_332 ctx, class_327 tr, String text, int mouseX, int mouseY) {
                ctx.method_51447(tr, class_341.method_1850((class_5348)class_2561.method_43470((String)text), (int)((int)((double)MessageList.this.field_22758 * 0.7)), (class_327)tr), mouseX, mouseY);
            }

            private void renderToolTip(class_332 ctx, class_327 tr, class_2561 text, int mouseX, int mouseY) {
                ctx.method_51447(tr, class_341.method_1850((class_5348)text, (int)((int)((double)MessageList.this.field_22758 * 0.7)), (class_327)tr), mouseX, mouseY);
            }

            @Nullable
            private class_2561 getToolTip(double mouseX, double mouseY) {
                class_327 tr = FullTextSearchResultScreen.this.field_22793;
                double scale = FullTextSearchResultScreen.this.field_22787.method_22683().method_4495();
                int pos = (int)Math.floor(mouseX - (double)(MessageList.this.method_46426() + 4) * scale);
                class_2583 style = tr.method_27527().method_30876(this.text, pos);
                if (style != null) {
                    class_2568 he = style.method_10969();
                    if (he != null && !class_437.method_25443()) {
                        return TextEventContentExtractor.getHoverEventContent(he);
                    }
                    class_2558 ce = style.method_10970();
                    if (ce != null) {
                        return class_2561.method_43470((String)TextEventContentExtractor.getClickEventContent(ce));
                    }
                }
                return null;
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                class_2561 tip;
                if (class_437.method_25441() && (tip = this.getToolTip(mouseX, mouseY)) != null) {
                    ((FullTextSearchResultScreen)FullTextSearchResultScreen.this).field_22787.field_1774.method_1455(tip.getString());
                    return true;
                }
                if (this.owner != null && class_156.method_658() - this.lastClick < 1000L) {
                    GuiUtils.loadSession(FullTextSearchResultScreen.this.field_22787, MessageList.this.currentSessionSummary, FullTextSearchResultScreen.this, this.ordinalInSession);
                    return true;
                }
                this.lastClick = class_156.method_658();
                return false;
            }

            public List<? extends class_364> method_25396() {
                return Collections.emptyList();
            }

            public List<? extends class_6379> method_37025() {
                return Collections.emptyList();
            }
        }
    }
}

