/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.gui;

import fr.raconteur.chatlogs.backup.config.Options;
import fr.raconteur.chatlogs.backup.gui.ExportSessionScreen;
import fr.raconteur.chatlogs.backup.gui.FilterSessionScreen;
import fr.raconteur.chatlogs.backup.gui.GuiUtils;
import fr.raconteur.chatlogs.backup.gui.SettingScreen;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5244;

public final class SessionListScreen
extends class_437 {
    private SessionList displayedSessions;
    private final Predicate<Session.Summary> filterer;
    private final boolean enablePaging = Options.sessionListPaging;

    public SessionListScreen() {
        super(I18N.translateAsText("gui.chatlogs"));
        this.filterer = s -> true;
    }

    public SessionListScreen(Predicate<Session.Summary> filterer) {
        super(I18N.translateAsText("gui.chatlogs"));
        this.filterer = filterer;
    }

    protected void method_25426() {
        this.displayedSessions = new SessionList(this.field_22787);
        this.method_37063((class_364)this.displayedSessions);
        int openBtnYPos = this.field_22790 - (this.enablePaging ? 46 : 23);
        class_4185 openBtn = class_4185.method_46430((class_2561)I18N.translateAsText("gui.open"), btn -> {
            SessionList.SessionEntry entry = (SessionList.SessionEntry)this.displayedSessions.method_25336();
            if (entry != null) {
                GuiUtils.loadSession(this.field_22787, entry.summary, this);
            }
        }).method_46434(this.field_22789 / 2 - 128, openBtnYPos, 80, 20).method_46431();
        class_4185 exportBtn = class_4185.method_46430((class_2561)I18N.translateAsText("gui.export"), btn -> {
            SessionList.SessionEntry entry = (SessionList.SessionEntry)this.displayedSessions.method_25336();
            if (entry != null) {
                this.field_22787.method_1507((class_437)new ExportSessionScreen(entry.summary));
            }
        }).method_46434(this.field_22789 / 2 - 40, openBtnYPos, 80, 20).method_46431();
        class_4185 deleteBtn = class_4185.method_46430((class_2561)I18N.translateAsText("gui.del"), btn -> {
            SessionList.SessionEntry entry = (SessionList.SessionEntry)this.displayedSessions.method_25336();
            if (entry != null) {
                this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                    if (confirmed) {
                        IntLinkedOpenHashSet ids = new IntLinkedOpenHashSet();
                        ids.add(entry.summary.id);
                        Session.delete((IntSet)ids);
                    }
                    this.field_22787.method_1507((class_437)this);
                }, I18N.translateAsText("gui.del.title"), I18N.translateAsText("gui.del.desc")));
            }
        }).method_46434(this.field_22789 / 2 + 48, openBtnYPos, 80, 20).method_46431();
        class_4185 filterBtn = class_4185.method_46430((class_2561)I18N.translateAsText("gui.filter"), btn -> this.field_22787.method_1507((class_437)new FilterSessionScreen())).method_46434(this.field_22789 / 2 - 128, 2, 80, 20).method_46431();
        class_4185 settingBtn = class_4185.method_46430((class_2561)I18N.translateAsText("gui.settings"), btn -> this.field_22787.method_1507((class_437)new SettingScreen())).method_46434(this.field_22789 / 2 - 40, 2, 80, 20).method_46431();
        class_4185 exitBtn = class_4185.method_46430((class_2561)class_5244.field_24339, btn -> this.field_22787.method_1507((class_437)new class_442())).method_46434(this.field_22789 / 2 + 48, 2, 80, 20).method_46431();
        if (this.enablePaging) {
            class_4185 prevBtn = class_4185.method_46430((class_2561)I18N.translateAsText("gui.prev"), btn -> this.displayedSessions.turnPage(false)).method_46434(this.field_22789 / 2 - 128, this.field_22790 - 23, 124, 20).method_46431();
            class_4185 nextBtn = class_4185.method_46430((class_2561)I18N.translateAsText("gui.next"), btn -> this.displayedSessions.turnPage(true)).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 23, 124, 20).method_46431();
            this.method_37063((class_364)prevBtn);
            this.method_37063((class_364)nextBtn);
        }
        this.method_37063((class_364)openBtn);
        this.method_37063((class_364)exportBtn);
        this.method_37063((class_364)deleteBtn);
        this.method_37063((class_364)filterBtn);
        this.method_37063((class_364)settingBtn);
        this.method_37063((class_364)exitBtn);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.displayedSessions.method_25394(ctx, mouseX, mouseY, delta);
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    private final class SessionList
    extends class_4280<SessionEntry> {
        private final List<Session.Summary> allSessions;
        private List<Session.Summary> visibleSessions;
        private int currentPage;

        public SessionList(class_310 mc) {
            super(mc, SessionListScreen.this.field_22789, SessionListScreen.this.field_22790 - (SessionListScreen.this.enablePaging ? 84 : 61), 30, 32);
            this.allSessions = Session.getSessionSummaries().stream().filter(SessionListScreen.this.filterer).sorted((s1, s2) -> (int)Math.signum((double)(s2.startTime - s1.startTime))).collect(Collectors.toList());
            this.currentPage = 0;
            this.toPage(0);
        }

        private void toPage(int i) {
            this.currentPage = i;
            this.visibleSessions = this.sessionsInPage(i);
            this.method_25339();
            this.visibleSessions.stream().map(x$0 -> new SessionEntry((Session.Summary)x$0)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            this.method_25395(null);
        }

        private List<Session.Summary> sessionsInPage(int i) {
            if (!SessionListScreen.this.enablePaging) {
                return this.allSessions;
            }
            int itemPerPage = Options.sessionsPerPage;
            int pageStart = i * itemPerPage;
            int pageEnd = Math.min(i * itemPerPage + itemPerPage - 1, this.allSessions.size());
            return this.allSessions.subList(pageStart, pageEnd);
        }

        public void turnPage(boolean next) {
            int target = this.currentPage + (next ? 1 : -1);
            int totalPages = (int)Math.ceil((double)this.allSessions.size() / (double)Options.sessionsPerPage);
            this.toPage(class_3532.method_15340((int)target, (int)0, (int)(totalPages - 1)));
        }

        private final class SessionEntry
        extends class_4280.class_4281<SessionEntry> {
            private final Session.Summary summary;
            private final class_2561 saveName;
            private final class_2561 start;
            private final class_2561 sizeAndTimeLength;

            public SessionEntry(Session.Summary info) {
                this.summary = info;
                this.saveName = class_2561.method_43470((String)info.saveName);
                this.start = class_2561.method_43470((String)info.getFormattedStartTime()).method_27692(class_124.field_1080);
                long delta = (long)Math.floor((info.endTime - info.startTime) / 1000L);
                this.sizeAndTimeLength = class_2561.method_43470((String)String.format(I18N.translate("gui.sizeandtime"), (int)Math.floor(delta / 3600L), (int)Math.floor(delta % 3600L / 60L), delta % 60L, info.size)).method_27692(class_124.field_1080);
            }

            public class_2561 method_37006() {
                return this.saveName;
            }

            public void method_25343(class_332 ctx, int i, int y, int x, int width, int height, int var7, int var8, boolean var9, float var10) {
                class_327 tr = ((SessionListScreen)SessionListScreen.this).field_22787.field_1772;
                ctx.method_51439(tr, this.saveName, x, y, -1, false);
                ctx.method_51439(tr, this.start, x, y + 10, -1, false);
                ctx.method_51439(tr, this.sizeAndTimeLength, x, y + 20, -1, false);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                SessionList.this.method_25395((class_364)this);
                return true;
            }
        }
    }
}

