/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.i18n;

import com.google.common.collect.ImmutableSet;
import fr.raconteur.chatlogs.backup.i18n.Language;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class I18N {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ImmutableSet<String> SUPPORTED_LANGUAGES = ImmutableSet.builder().add((Object[])new String[]{"zh_cn", "en_us"}).build();
    public static final Language EN_US;
    private static Language currentLanguage;

    public static String translate(String translationKey) {
        return currentLanguage.translate(translationKey);
    }

    public static String translate(String translationKey, Object ... args) {
        return String.format(I18N.translate(translationKey), args);
    }

    public static class_2561 translateAsText(String translationKey) {
        return class_2561.method_43470((String)I18N.translate(translationKey));
    }

    public static class_2561 translateAsText(String translationKey, Object ... args) {
        return class_2561.method_43470((String)I18N.translate(translationKey, args));
    }

    public static boolean setLanguage(String name) {
        if (name == null) {
            String sysLang;
            name = class_310.method_1551().field_1690 != null ? (SUPPORTED_LANGUAGES.contains((Object)(sysLang = class_310.method_1551().field_1690.field_1883)) ? sysLang : "en_us") : "en_us";
        } else if (!SUPPORTED_LANGUAGES.contains((Object)name)) {
            name = "en_us";
        }
        try {
            Language lang = new Language(name);
            if (lang.validate()) {
                currentLanguage = lang;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        try {
            EN_US = new Language("en_us");
            I18N.setLanguage(null);
        }
        catch (Exception e) {
            throw new class_148(new class_128("Couldn't load the default translation.", (Throwable)e));
        }
    }
}

