/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.i18n;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

class Language {
    private final String readableName;
    private final Map<String, String> translations = Maps.newHashMap();
    private final String id;

    public Language(String id) throws Exception {
        this.id = id;
        Path langFile = ((Path)((ModContainer)FabricLoader.getInstance().getModContainer("chatlogs").get()).getRootPaths().get(0)).resolve("assets/lang/" + id + ".json");
        try {
            JsonObject def = new JsonParser().parse(new String(Files.readAllBytes(langFile), Charset.forName("GBK"))).getAsJsonObject();
            this.readableName = def.get("readableName").getAsString();
            def.getAsJsonObject("translations").entrySet().forEach(e -> this.translations.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString()));
        }
        catch (Exception e2) {
            I18N.LOGGER.error("Failed to load the definition of language " + id);
            e2.printStackTrace();
            throw e2;
        }
    }

    public String translate(String key) {
        if (!this.translations.containsKey(key)) {
            I18N.LOGGER.warn("Unrecognized translation key: {}", (Object)key);
            return key;
        }
        return this.translations.get(key);
    }

    public String getName() {
        return this.readableName;
    }

    public boolean validate() {
        Set<String> en;
        if ("en_us".equals(this.id)) {
            return true;
        }
        Set<String> here = this.translations.keySet();
        if (here.containsAll(en = I18N.EN_US.translations.keySet()) && en.containsAll(here)) {
            return true;
        }
        en.stream().filter(key -> !here.contains(key)).forEach(key -> I18N.LOGGER.warn("Absence: " + key));
        here.stream().filter(key -> !en.contains(key)).forEach(key -> I18N.LOGGER.warn("Redunancy: " + key));
        return false;
    }

    public boolean containsKey(String mayKey) {
        return this.translations.containsKey(mayKey);
    }
}

