/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.session;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.raconteur.chatlogs.backup.config.Options;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.SessionRecorder;
import fr.raconteur.chatlogs.backup.session.SessionUtils;
import io.netty.util.internal.StringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_528;
import net.minecraft.class_8824;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Session {
    static final Logger LOGGER = LogManager.getLogger((String)"ChatlogSession");
    static final File CHATLOG_FOLDER = (File)class_156.method_656(() -> {
        boolean success;
        File f;
        block6: {
            f = new File("chatlogs");
            if (!f.exists()) {
                success = f.mkdir();
            } else if (!f.isDirectory()) {
                for (int i = 0; i < 10; ++i) {
                    String renameTo = "chatlogs" + System.currentTimeMillis() + i;
                    if (!f.renameTo(new File(renameTo))) continue;
                    LOGGER.warn("A non-directory file named 'chatlogs' already exists, renaming to {}.", (Object)renameTo);
                    success = f.mkdir();
                    break block6;
                }
                LOGGER.error("Failed to rename existing file {}, deleting", (Object)f.getAbsolutePath());
                success = f.delete() ? f.mkdir() : false;
            } else {
                return f;
            }
        }
        if (success) {
            return f;
        }
        LOGGER.fatal("Unable to create directory for chat logs.");
        throw new RuntimeException("Unable to create directory for chat logs.");
    });
    static final File INDEX = new File(CHATLOG_FOLDER, "index.ssv");
    private static final File INDEX_BACKUP = new File(CHATLOG_FOLDER, "index.bak");
    private final Deque<Line> messages;
    private final LinkedHashMap<UUID, String> uuidToName;
    private final Summary metadata;

    private Session(ArrayDeque<Line> messages, LinkedHashMap<UUID, String> uuidToName, Summary metadata) {
        this.messages = messages;
        this.uuidToName = uuidToName;
        this.metadata = metadata;
    }

    public Deque<Line> getMessages() {
        return this.messages;
    }

    public LinkedHashMap<UUID, String> getSendersByUuid() {
        return this.uuidToName;
    }

    public Summary getMetadata() {
        return this.metadata;
    }

    public static List<Summary> getSessionSummaries() {
        ArrayList<Summary> list = new ArrayList<Summary>();
        if (!INDEX.exists()) {
            try {
                INDEX.createNewFile();
            }
            catch (IOException e) {
                LOGGER.fatal("Failed to create index!");
                e.printStackTrace();
                throw new RuntimeException("Failed to create index!", e);
            }
        }
        try (Scanner s = new Scanner(new FileReader(INDEX));){
            while (s.hasNextLine()) {
                try {
                    list.add(new Summary(s.nextLine()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    private static boolean backupIndex() {
        try {
            Files.copy(INDEX.toPath(), INDEX_BACKUP.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to backup chat log index!");
            e.printStackTrace();
            return false;
        }
    }

    private static boolean restoreIndex() {
        try {
            Files.copy(INDEX_BACKUP.toPath(), INDEX.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to backup chat log index!");
            e.printStackTrace();
            return false;
        }
    }

    public static int delete(IntSet ids) {
        Session.backupIndex();
        List<Summary> summaries = Session.getSessionSummaries();
        IntOpenHashSet deleted = new IntOpenHashSet();
        IntIterator intIterator = ids.iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            if (!SessionUtils.id2File(id).delete()) continue;
            deleted.add(id);
        }
        INDEX.delete();
        try (PrintWriter pw = new PrintWriter(new FileWriter(INDEX));){
            for (Summary s : summaries) {
                if (deleted.contains(s.id)) continue;
                s.write(pw);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Session.restoreIndex();
        }
        return deleted.size();
    }

    public static boolean updateSummary(Summary summary) {
        Session.backupIndex();
        List<Summary> summaries = Session.getSessionSummaries();
        INDEX.delete();
        PrintWriter pw = new PrintWriter(new FileWriter(INDEX));
        try {
            for (Summary s : summaries) {
                if (s.id != summary.id) {
                    s.write(pw);
                    continue;
                }
                summary.write(pw);
            }
            boolean bl = true;
            pw.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                Session.restoreIndex();
                return false;
            }
        }
    }

    public List<Session> split(List<Line> delimiters) {
        if (delimiters.isEmpty()) {
            return List.of(this);
        }
        delimiters = new ArrayList<Line>(delimiters);
        delimiters.add(null);
        LinkedList<Line> remaining = new LinkedList<Line>(this.messages);
        ArrayList<Session> result = new ArrayList<Session>();
        Iterator<Line> itr = delimiters.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Line nextBorder = itr.next();
            ArrayDeque<Line> seg = new ArrayDeque<Line>();
            while (!remaining.isEmpty() && remaining.get(0) != nextBorder) {
                seg.add((Line)remaining.remove(0));
            }
            if (seg.isEmpty()) continue;
            Summary ori = this.metadata;
            long startTime = first ? ori.startTime : ((Line)seg.getFirst()).time;
            long endTime = itr.hasNext() ? ((Line)seg.getLast()).time : ori.endTime;
            Summary metadata = new Summary(SessionUtils.allocateId(), ori.saveName, startTime, endTime, seg.size(), ori.timeZone, ori.multiplayer, Version.LATEST);
            Session session = new Session(seg, this.uuidToName, metadata);
            result.add(session);
        }
        return result;
    }

    public Session clip(Line start, Line end) {
        if (start == null && end == null) {
            return this;
        }
        if (start == null) {
            return this.split(List.of(end)).get(0);
        }
        if (end == null) {
            return this.split(List.of(start)).get(1);
        }
        return this.split(List.of(start, end)).get(1);
    }

    public SessionRecorder continueRecording() {
        return new SessionRecorder(this);
    }

    public void save() {
        this.continueRecording().end0();
    }

    private static class_2561 parseTextJson(String json) {
        return (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)json)).getOrThrow()).getFirst();
    }

    private static String textToJson(class_2561 text) {
        return ((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)text).getOrThrow()).toString();
    }

    public static final class Summary {
        public final int id;
        public final String saveName;
        public final long startTime;
        public final long endTime;
        public final long size;
        public final TimeZone timeZone;
        public final Version version;
        public final boolean multiplayer;

        Summary(int id, String saveName, long startTime, long endTime, long size, TimeZone timeZone, boolean multiplayer, Version version) {
            this.id = id;
            this.saveName = saveName;
            this.startTime = startTime;
            this.endTime = endTime;
            this.size = size;
            this.timeZone = timeZone;
            this.version = version;
            this.multiplayer = multiplayer;
        }

        Summary(String idxLine) {
            Iterator itr = StringUtil.unescapeCsvFields((CharSequence)idxLine).stream().map(CharSequence::toString).iterator();
            this.id = Integer.parseInt((String)itr.next());
            this.saveName = (String)itr.next();
            this.startTime = Long.parseLong((String)itr.next());
            this.endTime = Long.parseLong((String)itr.next());
            this.size = Integer.parseInt((String)itr.next());
            this.timeZone = itr.hasNext() ? TimeZone.getTimeZone((String)itr.next()) : TimeZone.getDefault();
            this.version = itr.hasNext() ? Version.valueOf((String)itr.next()) : Version.EARLY_RELEASES;
            this.multiplayer = itr.hasNext() ? Boolean.valueOf((String)itr.next()) : false;
        }

        protected boolean write() {
            PrintWriter pw = new PrintWriter(new FileWriter(INDEX, true));
            try {
                this.write(pw);
                boolean bl = true;
                pw.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to write index!");
                    e.printStackTrace();
                    return false;
                }
            }
        }

        protected void write(PrintWriter pw) throws IOException {
            pw.println(String.format("%d,%s,%d,%d,%d,%s,%s,%s", this.id, StringUtil.escapeCsv((CharSequence)this.saveName), this.startTime, this.endTime, this.size, this.timeZone.getID(), this.version.name(), this.multiplayer));
        }

        public final Session load() {
            if (SessionUtils.checkAvailability(this.id)) {
                return null;
            }
            return this.version.load(this);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.endTime, this.id, this.multiplayer, this.saveName, this.size, this.startTime, this.timeZone, this.version});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Summary other = (Summary)obj;
            return this.endTime == other.endTime && this.id == other.id && this.multiplayer == other.multiplayer && Objects.equals(this.saveName, other.saveName) && this.size == other.size && this.startTime == other.startTime && Objects.equals(this.timeZone, other.timeZone) && this.version == other.version;
        }

        public final String getFormattedStartTime() {
            return Instant.ofEpochMilli(this.startTime).atZone(this.timeZone.toZoneId()).format(class_528.field_19132);
        }
    }

    public static class Line {
        public final UUID sender;
        public final class_2561 message;
        public final long time;

        protected Line(UUID sender, class_2561 message, long time) {
            this.sender = sender;
            this.message = message;
            this.time = time;
        }

        public static Proto parse(JsonReader jr) throws IOException {
            jr.beginObject();
            String msgJson = null;
            Integer sender = null;
            long time = 0L;
            block10: while (jr.hasNext()) {
                switch (jr.nextName()) {
                    case "sender": {
                        sender = jr.nextInt();
                        continue block10;
                    }
                    case "msgJson": {
                        msgJson = jr.nextString();
                        continue block10;
                    }
                    case "time": {
                        time = jr.nextLong();
                        continue block10;
                    }
                }
                jr.skipValue();
            }
            if (msgJson == null || sender == null) {
                throw new MalformedJsonException("Incomplete chat line");
            }
            jr.endObject();
            return new Proto(sender, Session.parseTextJson(msgJson), time);
        }

        static Line parseFull(String json) {
            JsonObject jo = new JsonParser().parse(json).getAsJsonObject();
            return new Line(UUID.fromString(jo.get("sender").getAsString()), Session.parseTextJson(jo.get("msgJson").getAsString()), jo.get("time").getAsLong());
        }

        JsonObject toJson() {
            JsonObject line = new JsonObject();
            line.addProperty("sender", this.sender.toString());
            line.addProperty("msgJson", Session.textToJson(this.message));
            line.addProperty("time", (Number)this.time);
            return line;
        }

        public int getMarkColor() {
            return -13503605;
        }

        protected static final class Proto {
            public final int senderId;
            public final class_2561 message;
            public final long time;

            protected Proto(int senderId, class_2561 message, long time) {
                this.senderId = senderId;
                this.message = message;
                this.time = time;
            }

            protected Line toLine(Int2ObjectMap<UUID> uuids) {
                return new Line((UUID)uuids.get(this.senderId), this.message, this.time);
            }
        }
    }

    public static enum Version {
        EARLY_RELEASES{

            @Override
            protected Session load(Summary summary) {
                File file = SessionUtils.id2File(summary.id);
                ArrayList protos = null;
                LinkedHashMap<UUID, String> uuidToName = null;
                Int2ObjectOpenHashMap uuids = new Int2ObjectOpenHashMap();
                try (InputStreamReader reader = new InputStreamReader(new GZIPInputStream(new FileInputStream(file)));){
                    JsonReader jr = new Gson().newJsonReader((Reader)reader);
                    jr.beginObject();
                    block27: while (jr.hasNext()) {
                        switch (jr.nextName()) {
                            case "messages": {
                                protos = new ArrayList();
                                jr.beginArray();
                                protos = new ArrayList();
                                ArrayList fuckLambda = protos;
                                SessionUtils.wrapTextSerialization(() -> {
                                    while (jr.hasNext()) {
                                        fuckLambda.add(Line.parse(jr));
                                    }
                                });
                                jr.endArray();
                                continue block27;
                            }
                            case "senders": {
                                uuidToName = new LinkedHashMap();
                                jr.beginArray();
                                while (jr.hasNext()) {
                                    jr.beginObject();
                                    Integer id = null;
                                    String name = null;
                                    Long uuid_m = null;
                                    Long uuid_l = null;
                                    block29: while (jr.hasNext()) {
                                        switch (jr.nextName()) {
                                            case "id": {
                                                id = jr.nextInt();
                                                continue block29;
                                            }
                                            case "name": {
                                                name = jr.nextString();
                                                continue block29;
                                            }
                                            case "uuid_m": {
                                                uuid_m = jr.nextLong();
                                                continue block29;
                                            }
                                            case "uuid_l": {
                                                uuid_l = jr.nextLong();
                                                continue block29;
                                            }
                                        }
                                        jr.skipValue();
                                    }
                                    if (id == null || name == null || uuid_m == null || uuid_l == null) {
                                        throw new MalformedJsonException("Incomplete sender info");
                                    }
                                    UUID uuid = new UUID(uuid_m, uuid_l);
                                    uuidToName.put(uuid, name);
                                    uuids.put(id.intValue(), (Object)uuid);
                                    jr.endObject();
                                }
                                jr.endArray();
                                continue block27;
                            }
                        }
                        jr.skipValue();
                    }
                    jr.endObject();
                }
                catch (IOException e1) {
                    LOGGER.error("Failed to load chat logs!");
                    e1.printStackTrace();
                    if (Options.allowCorruptedChatlogs) {
                        if (protos == null) {
                            protos = new ArrayList();
                        }
                        if (uuidToName == null) {
                            uuidToName = new LinkedHashMap<UUID, String>();
                        }
                    }
                    throw new RuntimeException("Failed to load chat logs!", e1);
                }
                if (uuidToName == null || protos == null) {
                    LOGGER.error("Incomplete chat log");
                    return null;
                }
                ArrayDeque currentChatLogs = protos.stream().map(arg_0 -> 1.lambda$load$1((Int2ObjectMap)uuids, arg_0)).collect(ArrayDeque::new, ArrayDeque::add, (r1, r2) -> {});
                return new Session(currentChatLogs, uuidToName, summary);
            }

            private static /* synthetic */ Line lambda$load$1(Int2ObjectMap uuids, Line.Proto p) {
                return p.toLine((Int2ObjectMap<UUID>)uuids);
            }
        }
        ,
        V_20240826{

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected Session load(Summary summary) {
                File file = SessionUtils.id2File(summary.id);
                try {
                    InputStreamReader s = new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
                    try {
                        LinkedHashMap<UUID, String> namesByUuid;
                        ArrayDeque<Line> lines;
                        block22: {
                            Version.readLine(s);
                            lines = new ArrayDeque<Line>();
                            namesByUuid = new LinkedHashMap<UUID, String>();
                            try {
                                String l;
                                block21: while ((l = Version.readLine(s)) != null) {
                                    switch (l.charAt(0)) {
                                        case 'M': {
                                            SessionUtils.wrapTextSerialization(() -> {
                                                try {
                                                    lines.add(Line.parseFull(l.substring(1)));
                                                }
                                                catch (Exception e) {
                                                    LOGGER.error("Failed to parse line: {}", (Object)l);
                                                    e.printStackTrace();
                                                }
                                            });
                                            break;
                                        }
                                        case 'S': {
                                            Scanner scannerForLine = new Scanner(l.substring(1));
                                            try {
                                                scannerForLine.useDelimiter(",");
                                                namesByUuid.put(UUID.fromString(scannerForLine.next()), StringUtil.unescapeCsv((CharSequence)scannerForLine.next()).toString());
                                                continue block21;
                                            }
                                            finally {
                                                scannerForLine.close();
                                                continue block21;
                                            }
                                        }
                                        case 'E': {
                                            SessionUtils.wrapTextSerialization(() -> lines.add(Event.parseEvent(l.substring(1))));
                                            break;
                                        }
                                        case 'W': {
                                            SessionUtils.wrapTextSerialization(() -> lines.add(WorldIndicator.parse(l.substring(1))));
                                            continue block21;
                                        }
                                    }
                                }
                            }
                            catch (JsonSyntaxException | MalformedJsonException | EOFException e) {
                                e.printStackTrace();
                                if (Options.allowCorruptedChatlogs) break block22;
                                Session session = null;
                                s.close();
                                return session;
                            }
                        }
                        Session session = new Session(lines, namesByUuid, summary);
                        return session;
                    }
                    finally {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable;
                            throwable.addSuppressed(throwable2);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load chatlog!");
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            protected Summary inferMetadata(File unsaved) {
                Scanner s = new Scanner(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(unsaved)))));
                try {
                    long endTime = unsaved.lastModified();
                    s.useDelimiter("[,\n]");
                    int id = Integer.parseInt(s.next());
                    String saveName = StringUtil.unescapeCsv((CharSequence)s.next()).toString();
                    long startTime = Long.parseLong(s.next());
                    TimeZone timeZone = TimeZone.getTimeZone(s.next());
                    s.nextLine();
                    int msgCnt = 0;
                    while (s.hasNextLine()) {
                        String l = s.nextLine();
                        if (l.charAt(0) != 'M' && l.charAt(0) != 'E') continue;
                        ++msgCnt;
                    }
                    Summary summary = new Summary(id, saveName, startTime, endTime, msgCnt, timeZone, false, this);
                    s.close();
                    return summary;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }
        ,
        V_20241011{

            @Override
            protected Session load(Summary summary) {
                return V_20240826.load(summary);
            }

            @Override
            protected Summary inferMetadata(File unsaved) {
                Summary summary;
                InputStreamReader s = new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(unsaved))));
                try {
                    long endTime = unsaved.lastModified();
                    String metaLine = Version.readLine(s);
                    Iterator itr = StringUtil.unescapeCsvFields((CharSequence)metaLine).stream().map(CharSequence::toString).iterator();
                    int id = Integer.parseInt((String)itr.next());
                    String saveName = (String)itr.next();
                    long startTime = Long.parseLong((String)itr.next());
                    TimeZone timeZone = TimeZone.getTimeZone((String)itr.next());
                    boolean multiplayer = itr.hasNext() ? Boolean.valueOf((String)itr.next()) : false;
                    int msgCnt = 0;
                    try {
                        String l;
                        while ((l = Version.readLine(s)) != null) {
                            if (l.charAt(0) != 'M' && l.charAt(0) != 'E') continue;
                            ++msgCnt;
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    summary = new Summary(id, saveName, startTime, endTime, msgCnt, timeZone, multiplayer, this);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                s.close();
                return summary;
            }
        };

        public static final Version LATEST;

        protected abstract Session load(Summary var1);

        protected Summary inferMetadata(File unsaved) {
            return null;
        }

        private static String readLine(Reader r) throws IOException {
            StringBuilder line = new StringBuilder();
            try {
                int c = r.read();
                while (c != 10 && c != 13 && c != -1) {
                    line.append((char)c);
                    c = r.read();
                }
                if (c == 13) {
                    r.skip(1L);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return line.length() == 0 ? null : line.toString();
        }

        static {
            LATEST = V_20241011;
        }
    }

    public static class WorldIndicator
    extends Line {
        private final boolean multiplayer;
        private final String saveName;

        protected WorldIndicator(String saveName, boolean multiplayer, long time) {
            super(class_156.field_25140, I18N.translateAsText(multiplayer ? "mark.worldindicate" : "mark.worldindicate.mp", saveName), time);
            this.saveName = saveName;
            this.multiplayer = multiplayer;
        }

        @Override
        public int getMarkColor() {
            return -4691616;
        }

        static Line parse(String json) {
            JsonObject jo = new JsonParser().parse(json).getAsJsonObject();
            return new WorldIndicator(jo.get("save").getAsString(), jo.get("multiplayer").getAsBoolean(), jo.get("time").getAsLong());
        }

        @Override
        JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("time", (Number)this.time);
            json.addProperty("save", this.saveName);
            json.addProperty("multiplayer", Boolean.valueOf(this.multiplayer));
            return json;
        }
    }

    public static final class Event
    extends Line {
        private final int markColor;

        public Event(class_2561 title, long time, int markColor) {
            super(class_156.field_25140, title, time);
            this.markColor = markColor;
        }

        @Override
        public int getMarkColor() {
            return 0xFF000000 | this.markColor;
        }

        static Line parseEvent(String json) {
            JsonObject jo = new JsonParser().parse(json).getAsJsonObject();
            return new Event(Session.parseTextJson(jo.get("msgJson").getAsString()), jo.get("time").getAsLong(), jo.get("color").getAsInt());
        }

        @Override
        JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("msgJson", Session.textToJson(this.message));
            json.addProperty("time", (Number)this.time);
            json.addProperty("color", (Number)this.markColor);
            return json;
        }
    }
}

