/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.session;

import fr.raconteur.chatlogs.backup.config.Options;
import fr.raconteur.chatlogs.backup.session.Session;
import fr.raconteur.chatlogs.backup.session.SessionUtils;
import fr.raconteur.chatlogs.backup.session.UnsavedChatlogRecovery;
import io.netty.util.internal.StringUtil;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.GZIPOutputStream;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_5223;
import net.minecraft.class_5348;
import org.apache.commons.lang3.StringUtils;

public class SessionRecorder {
    private static SessionRecorder current = null;
    private Deque<Session.Line> cachedChatLogs;
    private final LinkedHashMap<UUID, String> uuidToName;
    private final String saveName;
    private final int id;
    private final long startTime;
    private final TimeZone timeZone;
    private long messageCount = 0L;
    private final Session.Version version;
    private final boolean multiplayer;
    private volatile boolean finalSaving = false;
    private final Thread autosaveWorker;

    SessionRecorder(String saveName, boolean multiplayer) {
        this.cachedChatLogs = new ConcurrentLinkedDeque<Session.Line>();
        this.uuidToName = new LinkedHashMap();
        this.id = SessionUtils.allocateId();
        this.saveName = saveName;
        this.startTime = System.currentTimeMillis();
        this.timeZone = TimeZone.getDefault();
        this.version = Session.Version.LATEST;
        this.multiplayer = multiplayer;
        this.autosaveWorker = new AutosaveWorker();
        this.autosaveWorker.start();
        this.writeSummary();
    }

    SessionRecorder(Session existing) {
        this.cachedChatLogs = existing.getMessages();
        this.uuidToName = existing.getSendersByUuid();
        Session.Summary metadata = existing.getMetadata();
        this.id = metadata.id;
        this.saveName = metadata.saveName;
        this.startTime = metadata.startTime;
        this.timeZone = metadata.timeZone;
        this.version = metadata.version;
        this.multiplayer = metadata.multiplayer;
        this.autosaveWorker = new AutosaveWorker();
        this.autosaveWorker.start();
    }

    public static SessionRecorder start(String saveName, boolean multiplayer) {
        if (Options.newSessionPerMcLaunch) {
            SessionRecorder recorder;
            SessionRecorder sessionRecorder = recorder = current == null ? SessionRecorder.startAnew(saveName, multiplayer) : current;
            if (Options.gameSessionIndicator) {
                recorder.addWorldIndicator(saveName, multiplayer);
            }
            return recorder;
        }
        return SessionRecorder.startAnew(saveName, multiplayer);
    }

    private static SessionRecorder startAnew(String saveName, boolean multiplayer) {
        SessionRecorder recorder = new SessionRecorder(saveName, multiplayer);
        UnsavedChatlogRecovery.markUnsaved(SessionUtils.id2File(recorder.id));
        current = recorder;
        return recorder;
    }

    public static SessionRecorder current() {
        return current;
    }

    public static void end(boolean clientExiting) {
        if (current == null) {
            return;
        }
        current.updateSummary();
        if (!Options.newSessionPerMcLaunch || clientExiting) {
            current.end0();
            current = null;
        }
    }

    public void onMessage(UUID sender, class_2561 msg) {
        long timestamp = class_156.method_659();
        this.cachedChatLogs.addLast(new Session.Line(sender, msg, timestamp));
        this.uuidToName.computeIfAbsent(sender, uuid -> {
            String string = class_5223.method_31402((class_5348)msg);
            String name = StringUtils.substringBetween((String)string, (String)"<", (String)">");
            return name == null ? "[UNSPECIFIED]" : name;
        });
        ++this.messageCount;
    }

    public void addEvent(Session.Event e) {
        this.cachedChatLogs.add(e);
        ++this.messageCount;
    }

    public int getId() {
        return this.id;
    }

    private void addWorldIndicator(String saveName, boolean multiplayer) {
        this.cachedChatLogs.add(new Session.WorldIndicator(saveName, multiplayer, class_156.method_659()));
    }

    void end0() {
        this.finalSaving = true;
        try {
            this.autosaveWorker.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Session.Summary toSummary() {
        return new Session.Summary(this.id, this.saveName, this.startTime, class_156.method_659(), this.messageCount, this.timeZone, this.multiplayer, this.version);
    }

    private boolean writeSummary() {
        return this.toSummary().write();
    }

    private void updateSummary() {
        Session.updateSummary(this.toSummary());
    }

    private final class AutosaveWorker
    extends Thread {
        private PrintWriter chatlogWriter;
        private int lastAutoSaveSendererCount;
        private int finalLoops;
        private final File chatlogFile;
        private final File lockFile;
        private FileOutputStream lockHolder;

        protected AutosaveWorker() {
            PrintWriter backend;
            super("ChatLog Autosave Worker");
            this.lastAutoSaveSendererCount = 0;
            this.finalLoops = 2;
            this.chatlogFile = SessionUtils.id2File(SessionRecorder.this.id);
            try {
                FileOutputStream fos = new FileOutputStream(this.chatlogFile);
                backend = new PrintWriter(new OutputStreamWriter(new GZIPOutputStream((OutputStream)new BufferedOutputStream(fos), true)));
                backend.println(String.format("%d,%s,%d,%s,%s", SessionRecorder.this.id, StringUtil.escapeCsv((CharSequence)SessionRecorder.this.saveName), SessionRecorder.this.startTime, SessionRecorder.this.timeZone.getID(), SessionRecorder.this.multiplayer));
                backend.flush();
            }
            catch (IOException e) {
                Session.LOGGER.error("Failed to create temp file for chat logs!");
                e.printStackTrace();
                throw new RuntimeException();
            }
            this.chatlogWriter = backend;
            this.lockFile = SessionUtils.lockFileOf(this.chatlogFile);
            try {
                this.lockHolder = new FileOutputStream(this.lockFile);
                if (this.lockHolder.getChannel().tryLock() == null) {
                    Session.LOGGER.error("Failed to lock chatlog file: {}", (Object)this.chatlogFile);
                }
            }
            catch (IOException e) {
                Session.LOGGER.error("Failed to lock chatlog file: {}", (Object)this.chatlogFile);
                e.printStackTrace();
                this.lockHolder = null;
            }
        }

        private static char getLineTypeMarker(Session.Line l) {
            if (l instanceof Session.Event) {
                return 'E';
            }
            if (l instanceof Session.WorldIndicator) {
                return 'W';
            }
            return 'M';
        }

        @Override
        public void run() {
            while (!SessionRecorder.this.finalSaving || this.finalLoops-- > 0) {
                try {
                    ArrayList<Map.Entry<UUID, String>> senders = new ArrayList<Map.Entry<UUID, String>>(SessionRecorder.this.uuidToName.entrySet());
                    List sendersToSave = senders.subList(this.lastAutoSaveSendererCount, senders.size());
                    this.lastAutoSaveSendererCount = senders.size();
                    for (Map.Entry e : sendersToSave) {
                        this.chatlogWriter.print(String.format("S%s,%s\n", ((UUID)e.getKey()).toString(), StringUtil.escapeCsv((CharSequence)((CharSequence)e.getValue()))));
                    }
                    SessionUtils.wrapTextSerialization(() -> {
                        while (!SessionRecorder.this.cachedChatLogs.isEmpty()) {
                            Session.Line l = SessionRecorder.this.cachedChatLogs.pollFirst();
                            this.chatlogWriter.print(AutosaveWorker.getLineTypeMarker(l));
                            this.chatlogWriter.print(l.toJson());
                            this.chatlogWriter.append('\n');
                        }
                    });
                    this.chatlogWriter.flush();
                    Thread.sleep(Options.realtimeChatlogSaving ? 0L : (long)Options.autoSaveIntervalInMs);
                }
                catch (Exception e) {
                    Session.LOGGER.error("Failed to perform autosave!");
                    e.printStackTrace();
                }
            }
            this.chatlogWriter.close();
            if (SessionRecorder.this.messageCount == 0L) {
                Session.delete(IntSet.of((int)SessionRecorder.this.id));
                UnsavedChatlogRecovery.unmarkUnsaved(this.chatlogFile);
                return;
            }
            if (this.lockHolder != null) {
                try {
                    this.lockHolder.close();
                    this.lockFile.delete();
                }
                catch (IOException e) {
                    Session.LOGGER.error("Failed to unlock chatlog file: {}", (Object)this.chatlogFile);
                    e.printStackTrace();
                }
            }
            Session.LOGGER.info("Saved chatlog to: {}", (Object)this.chatlogFile);
            UnsavedChatlogRecovery.unmarkUnsaved(this.chatlogFile);
        }
    }
}

