/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.session;

import fr.raconteur.chatlogs.ChatLogsMod;
import fr.raconteur.chatlogs.backup.session.Session;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;

class SessionUtils {
    private static final File NEXT_ID_STORAGE_OLD = FabricLoader.getInstance().getConfigDir().resolve("chatlogs.prop").toFile();
    private static final File NEXT_ID_STORAGE = new File(Session.CHATLOG_FOLDER, "next_id");

    SessionUtils() {
    }

    static void wrapTextSerialization(RunnableWithIOException task) throws IOException {
        try {
            ChatLogsMod.PERMISSIVE_EVENTS.set(true);
            task.run();
        }
        finally {
            ChatLogsMod.PERMISSIVE_EVENTS.set(false);
        }
    }

    private static void tryMigrateNextIdStorage() {
        int id;
        if (NEXT_ID_STORAGE.exists()) {
            return;
        }
        if (NEXT_ID_STORAGE_OLD.exists()) {
            Properties prop = new Properties();
            try (FileReader fr = new FileReader(NEXT_ID_STORAGE_OLD);){
                prop.load(fr);
                String nextIdStr = prop.computeIfAbsent("nextId", (Function<? super Object, ?>)((Function<Object, Object>)k -> "0")).toString();
                if (!nextIdStr.matches("\\d+")) {
                    Session.LOGGER.error("Invalid next ID: {}", (Object)nextIdStr);
                    id = 0x100000;
                } else {
                    id = Integer.parseInt(nextIdStr);
                }
            }
            catch (IOException e) {
                Session.LOGGER.error("Unable read from old ID counter!");
                e.printStackTrace();
                id = 0x100000;
            }
        } else {
            id = 0;
        }
        try (FileWriter fw = new FileWriter(NEXT_ID_STORAGE);){
            fw.write(Integer.toString(id));
        }
        catch (IOException e) {
            Session.LOGGER.error("Unable to create new ID counter!");
            e.printStackTrace();
        }
    }

    static int allocateId() {
        int id;
        SessionUtils.tryMigrateNextIdStorage();
        try (Scanner s = new Scanner(new FileReader(NEXT_ID_STORAGE));){
            id = s.nextInt();
        }
        catch (IOException e) {
            Session.LOGGER.error("Unable read from ID counter!");
            e.printStackTrace();
            id = new Random().nextInt();
        }
        while (!SessionUtils.checkAvailability(id)) {
            ++id;
        }
        try (FileWriter fw = new FileWriter(NEXT_ID_STORAGE);){
            fw.write(Integer.toString(id + 1));
        }
        catch (IOException e) {
            Session.LOGGER.error("Unable to save ID counter!");
            e.printStackTrace();
        }
        return id;
    }

    static boolean checkAvailability(int id) {
        return !SessionUtils.id2File(id).exists();
    }

    static File id2File(int id) {
        return new File(Session.CHATLOG_FOLDER, String.format("log-%d.json", id));
    }

    static File lockFileOf(File log) {
        return new File(log.getAbsolutePath() + ".lock");
    }

    @FunctionalInterface
    static interface RunnableWithIOException {
        public void run() throws IOException;
    }
}

