/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.backup.session;

import fr.raconteur.chatlogs.backup.config.Options;
import fr.raconteur.chatlogs.backup.i18n.I18N;
import fr.raconteur.chatlogs.backup.session.Session;
import fr.raconteur.chatlogs.backup.session.SessionRecorder;
import fr.raconteur.chatlogs.backup.session.SessionUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

public class UnsavedChatlogRecovery {
    private static final File UNSAVED_MARKER = new File(Session.CHATLOG_FOLDER, "unsaved.marker");

    static void markUnsaved(File unsaved) {
        UnsavedChatlogRecovery.waitForFile(UNSAVED_MARKER);
        try (FileWriter fw = new FileWriter(UNSAVED_MARKER, true);){
            fw.append(unsaved.getAbsolutePath());
            fw.append('\n');
        }
        catch (IOException e) {
            Session.LOGGER.warn("Unable to create unsaved marker!");
            e.printStackTrace();
        }
    }

    static void unmarkUnsaved(File unsaved) {
        if (unsaved != null) {
            UnsavedChatlogRecovery.waitForFile(UNSAVED_MARKER);
            ArrayList<String> filtered = new ArrayList<String>();
            String unsavedFilePath = unsaved.getAbsolutePath();
            try (Scanner s = new Scanner(new FileReader(UNSAVED_MARKER));){
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    if (line.equals(unsavedFilePath) || line.isEmpty()) continue;
                    filtered.add(line);
                }
            }
            catch (IOException e) {
                Session.LOGGER.warn("Unable to load unsaved marker!");
                e.printStackTrace();
            }
            UnsavedChatlogRecovery.waitForFile(UNSAVED_MARKER);
            try (FileWriter fw = new FileWriter(UNSAVED_MARKER);){
                for (String l : filtered) {
                    fw.append(l);
                    fw.append('\n');
                }
            }
            catch (IOException e) {
                Session.LOGGER.warn("Unable to save unsaved marker!");
                e.printStackTrace();
            }
        } else {
            UNSAVED_MARKER.delete();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isFileInUse(File f) {
        if (!f.exists()) {
            return false;
        }
        try (RandomAccessFile raf = new RandomAccessFile(f, "rw");){
            boolean bl;
            block19: {
                FileLock lock;
                FileChannel channel;
                block17: {
                    boolean bl2;
                    block18: {
                        channel = raf.getChannel();
                        try {
                            lock = channel.tryLock();
                            if (lock != null) break block17;
                            bl2 = true;
                            if (channel == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        channel.close();
                    }
                    return bl2;
                }
                lock.release();
                bl = false;
                if (channel == null) break block19;
                channel.close();
            }
            return bl;
        }
        catch (OverlappingFileLockException e) {
            return true;
        }
        catch (IOException e1) {
            return true;
        }
    }

    private static void waitForFile(File f) {
        while (UnsavedChatlogRecovery.isFileInUse(f)) {
            LockSupport.parkNanos(1000000L);
        }
    }

    private static List<File> getUnsaved() {
        ArrayList<File> unsaved = new ArrayList<File>();
        UnsavedChatlogRecovery.waitForFile(UNSAVED_MARKER);
        try (Scanner s = new Scanner(new FileReader(UNSAVED_MARKER));){
            while (s.hasNextLine()) {
                unsaved.add(new File(s.nextLine()));
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return unsaved;
    }

    public static void tryRestoreUnsaved() {
        if (Options.newSessionPerMcLaunch && SessionRecorder.current() != null) {
            return;
        }
        UnsavedChatlogRecovery.getUnsaved().forEach(UnsavedChatlogRecovery::tryRestoreUnsaved);
    }

    private static void tryRestoreUnsaved(File unsaved) {
        Session.Version ver;
        if (unsaved == null || UnsavedChatlogRecovery.isFileInUse(SessionUtils.lockFileOf(unsaved)) || !unsaved.exists()) {
            return;
        }
        boolean success = false;
        Session.Version[] loaders = Session.Version.values();
        Session.Summary summary = null;
        for (int i = loaders.length - 1; i >= 0 && (summary = (ver = loaders[i]).inferMetadata(unsaved)) == null; --i) {
        }
        if (summary == null) {
            return;
        }
        if (summary.size == 0L) {
            UnsavedChatlogRecovery.unmarkUnsaved(unsaved);
            return;
        }
        int id = summary.id;
        success = Session.getSessionSummaries().stream().anyMatch(s -> s.id == id) ? Session.updateSummary(summary) : summary.write();
        if (!success) {
            class_370 warning = new class_370(new class_370.class_9037(), I18N.translateAsText("gui.restore.failure"), I18N.translateAsText("gui.restore.failure.desc"));
            class_310.method_1551().method_1566().method_1999((class_368)warning);
        }
        SessionUtils.lockFileOf(unsaved).delete();
        UnsavedChatlogRecovery.unmarkUnsaved(unsaved);
    }
}

