/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import fr.raconteur.chatlogs.ChatLogsMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_156;

public class ChatLogsConfig {
    private static final String CONFIG_FILE_NAME = "chatlogs-config.json";
    public static final File CONFIG_FOLDER = (File)class_156.method_656(() -> {
        File f = new File("config");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    });
    private static final File CONFIG_FILE = new File(CONFIG_FOLDER, "chatlogs-config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ChatLogsConfig instance;
    private Map<String, List<String>> senderRegexPatterns = new HashMap<String, List<String>>();
    private Map<String, List<Pattern>> compiledPatterns = new HashMap<String, List<Pattern>>();

    private ChatLogsConfig() {
        this.loadConfig();
    }

    public static ChatLogsConfig getInstance() {
        if (instance == null) {
            instance = new ChatLogsConfig();
        }
        return instance;
    }

    public String extractSenderName(String sessionName, String messageText) {
        List<Pattern> patterns = this.getCompiledPatternsForSession(sessionName);
        for (Pattern pattern : patterns) {
            try {
                Matcher matcher = pattern.matcher(messageText);
                if (!matcher.find()) continue;
                try {
                    String sender = matcher.group("sender");
                    if (sender == null || sender.trim().isEmpty()) continue;
                    return sender.trim();
                }
                catch (IllegalArgumentException e) {
                    ChatLogsMod.LOGGER.warn("Pattern '{}' matched but has no 'sender' group: {}", (Object)pattern.pattern(), (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                ChatLogsMod.LOGGER.error("Error applying regex pattern '{}' to message '{}': {}", (Object)pattern.pattern(), (Object)messageText, (Object)e.getMessage());
            }
        }
        return null;
    }

    private List<Pattern> getCompiledPatternsForSession(String sessionName) {
        List<Pattern> patterns = this.compiledPatterns.get(sessionName);
        if (patterns != null && !patterns.isEmpty()) {
            return patterns;
        }
        patterns = this.compiledPatterns.get("default");
        if (patterns != null && !patterns.isEmpty()) {
            return patterns;
        }
        ChatLogsMod.LOGGER.warn("No regex patterns found for session '{}' or 'default'", (Object)sessionName);
        return new ArrayList<Pattern>();
    }

    private void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            this.createDefaultConfig();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Type type = new TypeToken<Map<String, List<String>>>(this){}.getType();
            Map loadedConfig = (Map)GSON.fromJson((Reader)reader, type);
            if (loadedConfig == null || !this.isValidConfig(loadedConfig)) {
                ChatLogsMod.LOGGER.warn("Invalid config format in {}, recreating with defaults", (Object)CONFIG_FILE_NAME);
                this.createDefaultConfig();
                return;
            }
            this.senderRegexPatterns = loadedConfig;
            this.compilePatterns();
            ChatLogsMod.LOGGER.info("Loaded chat logs config with {} session pattern groups", (Object)this.senderRegexPatterns.size());
        }
        catch (JsonSyntaxException | IOException e) {
            ChatLogsMod.LOGGER.error("Failed to load config from {}, recreating with defaults: {}", (Object)CONFIG_FILE_NAME, (Object)e.getMessage());
            this.createDefaultConfig();
        }
    }

    private boolean isValidConfig(Map<String, List<String>> config) {
        if (config.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : config.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) {
                return false;
            }
            for (String pattern : entry.getValue()) {
                if (pattern != null) continue;
                return false;
            }
        }
        return true;
    }

    private void createDefaultConfig() {
        HashMap<String, List<String>> defaultConfig = new HashMap<String, List<String>>();
        ArrayList<String> defaultPatterns = new ArrayList<String>();
        defaultPatterns.add("^(?:\\[[^\\[\\]]*\\])?\\s*<(?<sender>.*)>.*");
        defaultConfig.put("default", defaultPatterns);
        this.senderRegexPatterns = defaultConfig;
        this.saveConfig();
        this.compilePatterns();
        ChatLogsMod.LOGGER.info("Created default chat logs config at {}", (Object)CONFIG_FILE.getPath());
    }

    private void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson(this.senderRegexPatterns, (Appendable)writer);
            }
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.error("Failed to save config to {}: {}", (Object)CONFIG_FILE_NAME, (Object)e.getMessage());
        }
    }

    private void compilePatterns() {
        this.compiledPatterns.clear();
        for (Map.Entry<String, List<String>> entry : this.senderRegexPatterns.entrySet()) {
            String sessionKey = entry.getKey();
            List<String> patternStrings = entry.getValue();
            ArrayList<Pattern> compiled = new ArrayList<Pattern>();
            for (String patternString : patternStrings) {
                try {
                    Pattern pattern = Pattern.compile(patternString);
                    compiled.add(pattern);
                }
                catch (PatternSyntaxException e) {
                    ChatLogsMod.LOGGER.error("Invalid regex pattern for session '{}': '{}' - {}", (Object)sessionKey, (Object)patternString, (Object)e.getMessage());
                }
            }
            if (compiled.isEmpty()) continue;
            this.compiledPatterns.put(sessionKey, compiled);
            ChatLogsMod.LOGGER.debug("Compiled {} regex patterns for session '{}'", (Object)compiled.size(), (Object)sessionKey);
        }
    }

    public Map<String, List<String>> getRawConfig() {
        return new HashMap<String, List<String>>(this.senderRegexPatterns);
    }
}

