/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.database;

import fr.raconteur.chatlogs.ChatLogsMod;
import fr.raconteur.chatlogs.database.AbstractDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SessionDatabase
extends AbstractDatabase {
    private static SessionDatabase instance;
    private static final Object INSTANCE_LOCK;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private PreparedStatement insertSessionStmt;
    private PreparedStatement updateSessionStmt;
    private PreparedStatement insertMessageStmt;
    private PreparedStatement updateMessageCountStmt;

    private SessionDatabase() throws SQLException {
        super("sessions.db");
        this.prepareStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionDatabase getInstance() throws SQLException {
        if (instance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new SessionDatabase();
                }
            }
        }
        return instance;
    }

    private void prepareStatements() throws SQLException {
        this.insertSessionStmt = this.getConnection().prepareStatement("INSERT INTO sessions (session_name, start_time, is_multiplayer, txt_file_path, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?)", 1);
        this.updateSessionStmt = this.getConnection().prepareStatement("UPDATE sessions SET end_time = ?, message_count = ?, updated_at = ? WHERE id = ?");
        this.insertMessageStmt = this.getConnection().prepareStatement("INSERT INTO messages (session_id, sender_name, message_text, message_json, timestamp, created_at) VALUES (?, ?, ?, ?, ?, ?)");
        this.updateMessageCountStmt = this.getConnection().prepareStatement("UPDATE sessions SET message_count = message_count + ?, updated_at = ? WHERE id = ?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSession(String sessionName, boolean isMultiplayer, String txtFilePath) throws SQLException {
        this.lock.writeLock().lock();
        try {
            long l = this.executeInTransaction((Connection conn) -> {
                long currentTime = System.currentTimeMillis();
                this.insertSessionStmt.setString(1, sessionName);
                this.insertSessionStmt.setLong(2, currentTime);
                this.insertSessionStmt.setBoolean(3, isMultiplayer);
                this.insertSessionStmt.setString(4, txtFilePath);
                this.insertSessionStmt.setLong(5, currentTime);
                this.insertSessionStmt.setLong(6, currentTime);
                int affectedRows = this.insertSessionStmt.executeUpdate();
                if (affectedRows == 0) {
                    throw new SQLException("Failed to create session, no rows affected");
                }
                try (ResultSet rs = this.insertSessionStmt.getGeneratedKeys();){
                    if (rs.next()) {
                        long sessionId = rs.getLong(1);
                        ChatLogsMod.LOGGER.info("Created new session: {} (ID: {})", (Object)sessionName, (Object)sessionId);
                        Long l = sessionId;
                        return l;
                    }
                    throw new SQLException("Failed to create session, no ID obtained");
                }
            });
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(long sessionId, String senderName, String messageText, String messageJson) throws SQLException {
        this.lock.writeLock().lock();
        try {
            this.executeInTransaction((Connection conn) -> {
                long currentTime = System.currentTimeMillis();
                this.insertMessageStmt.setLong(1, sessionId);
                this.insertMessageStmt.setString(2, senderName);
                this.insertMessageStmt.setString(3, messageText);
                this.insertMessageStmt.setString(4, messageJson);
                this.insertMessageStmt.setLong(5, currentTime);
                this.insertMessageStmt.setLong(6, currentTime);
                this.insertMessageStmt.executeUpdate();
                this.updateMessageCountStmt.setInt(1, 1);
                this.updateMessageCountStmt.setLong(2, currentTime);
                this.updateMessageCountStmt.setLong(3, sessionId);
                this.updateMessageCountStmt.executeUpdate();
                return null;
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessagesBulk(long sessionId, List<MessageData> messages) throws SQLException {
        if (messages.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.executeInTransaction((Connection conn) -> {
                long currentTime = System.currentTimeMillis();
                for (MessageData msg : messages) {
                    this.insertMessageStmt.setLong(1, sessionId);
                    this.insertMessageStmt.setString(2, msg.senderName);
                    this.insertMessageStmt.setString(3, msg.messageText);
                    this.insertMessageStmt.setString(4, msg.messageJson);
                    this.insertMessageStmt.setLong(5, msg.timestamp);
                    this.insertMessageStmt.setLong(6, currentTime);
                    this.insertMessageStmt.addBatch();
                }
                this.insertMessageStmt.executeBatch();
                this.updateMessageCountStmt.setInt(1, messages.size());
                this.updateMessageCountStmt.setLong(2, currentTime);
                this.updateMessageCountStmt.setLong(3, sessionId);
                this.updateMessageCountStmt.executeUpdate();
                ChatLogsMod.LOGGER.debug("Added {} messages to session {}", (Object)messages.size(), (Object)sessionId);
                return null;
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void endSession(long sessionId) throws SQLException {
        this.lock.writeLock().lock();
        try {
            this.executeInTransaction((Connection conn) -> {
                long currentTime = System.currentTimeMillis();
                this.updateSessionStmt.setLong(1, currentTime);
                this.updateSessionStmt.setNull(2, 4);
                this.updateSessionStmt.setLong(3, currentTime);
                this.updateSessionStmt.setLong(4, sessionId);
                int affectedRows = this.updateSessionStmt.executeUpdate();
                if (affectedRows > 0) {
                    ChatLogsMod.LOGGER.info("Ended session: {}", (Object)sessionId);
                } else {
                    ChatLogsMod.LOGGER.warn("Failed to end session: {} (not found)", (Object)sessionId);
                }
                return null;
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<SessionData> getAllSessions() throws SQLException {
        this.lock.readLock().lock();
        try {
            List list = this.executeInTransaction((Connection conn) -> {
                ArrayList<SessionData> sessions = new ArrayList<SessionData>();
                String query = "SELECT * FROM sessions ORDER BY start_time DESC";
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery(query);){
                    while (rs.next()) {
                        SessionData session = new SessionData(rs.getLong("id"), rs.getString("session_name"), rs.getLong("start_time"), rs.getLong("end_time"), rs.getBoolean("is_multiplayer"), rs.getString("txt_file_path"), rs.getInt("message_count"));
                        sessions.add(session);
                    }
                }
                return sessions;
            });
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageData> getMessagesForSession(long sessionId) throws SQLException {
        this.lock.readLock().lock();
        try {
            List list = this.executeInTransaction((Connection conn) -> {
                ArrayList<MessageData> messages = new ArrayList<MessageData>();
                String query = "SELECT * FROM messages WHERE session_id = ? ORDER BY timestamp ASC";
                try (PreparedStatement stmt = conn.prepareStatement(query);){
                    stmt.setLong(1, sessionId);
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            MessageData message = new MessageData(rs.getString("sender_name"), rs.getString("message_text"), rs.getString("message_json"), rs.getLong("timestamp"));
                            messages.add(message);
                        }
                    }
                }
                return messages;
            });
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        this.lock.writeLock().lock();
        try {
            if (this.insertSessionStmt != null) {
                this.insertSessionStmt.close();
            }
            if (this.updateSessionStmt != null) {
                this.updateSessionStmt.close();
            }
            if (this.insertMessageStmt != null) {
                this.insertMessageStmt.close();
            }
            if (this.updateMessageCountStmt != null) {
                this.updateMessageCountStmt.close();
            }
            super.close();
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                instance = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static {
        INSTANCE_LOCK = new Object();
    }

    public static class MessageData {
        public final String senderName;
        public final String messageText;
        public final String messageJson;
        public final long timestamp;

        public MessageData(String senderName, String messageText, String messageJson, long timestamp) {
            this.senderName = senderName;
            this.messageText = messageText;
            this.messageJson = messageJson;
            this.timestamp = timestamp;
        }
    }

    public static class SessionData {
        public final long id;
        public final String sessionName;
        public final long startTime;
        public final long endTime;
        public final boolean isMultiplayer;
        public final String txtFilePath;
        public final int messageCount;

        public SessionData(long id, String sessionName, long startTime, long endTime, boolean isMultiplayer, String txtFilePath, int messageCount) {
            this.id = id;
            this.sessionName = sessionName;
            this.startTime = startTime;
            this.endTime = endTime;
            this.isMultiplayer = isMultiplayer;
            this.txtFilePath = txtFilePath;
            this.messageCount = messageCount;
        }
    }
}

