/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.mixin;

import fr.raconteur.chatlogs.ChatLogsMod;
import fr.raconteur.chatlogs.session.SimpleSessionRecorder;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_6904;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin {
    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;Z)V"}, at={@At(value="HEAD")})
    private void onDisconnected(CallbackInfo ci) {
        ChatLogsMod.LOGGER.debug("Disconnecting - ending chat log session");
        SimpleSessionRecorder.end();
    }

    @Inject(method={"stop"}, at={@At(value="INVOKE", target="java/lang/System.exit(I)V")})
    private void onStop(CallbackInfo ci) {
        ChatLogsMod.LOGGER.info("Minecraft client stopping - ending chat log session");
        SimpleSessionRecorder.end();
    }

    @Inject(method={"startIntegratedServer"}, at={@At(value="INVOKE", target="net/minecraft/client/MinecraftClient.disconnectWithProgressScreen()V", shift=At.Shift.AFTER)})
    private void onStartSingleplayer(class_32.class_5143 session, class_3283 dataPackManager, class_6904 saveLoader, boolean newWorld, CallbackInfo ci) {
        String worldName = session.method_27005();
        ChatLogsMod.LOGGER.info("Starting singleplayer world '{}' - beginning chat log session", (Object)worldName);
        SimpleSessionRecorder.start(worldName, false);
    }
}

