/*
 * Decompiled with CFR 0.152.
 */
package fr.raconteur.chatlogs.session;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.raconteur.chatlogs.ChatLogsMod;
import fr.raconteur.chatlogs.config.ChatLogsConfig;
import fr.raconteur.chatlogs.database.SessionDatabase;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_8824;

public class SimpleSessionRecorder {
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter FILE_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    public static final File CHATLOG_FOLDER = (File)class_156.method_656(() -> {
        boolean success;
        File f;
        block6: {
            f = new File("chatlogs");
            if (!f.exists()) {
                success = f.mkdir();
            } else if (!f.isDirectory()) {
                for (int i = 0; i < 10; ++i) {
                    String renameTo = "chatlogs" + System.currentTimeMillis() + i;
                    if (!f.renameTo(new File(renameTo))) continue;
                    ChatLogsMod.LOGGER.warn("A non-directory file named 'chatlogs' already exists, renaming to {}.", (Object)renameTo);
                    success = f.mkdir();
                    break block6;
                }
                ChatLogsMod.LOGGER.error("Failed to rename existing file {}, deleting", (Object)f.getAbsolutePath());
                success = f.delete() ? f.mkdir() : false;
            } else {
                return f;
            }
        }
        if (success) {
            return f;
        }
        ChatLogsMod.LOGGER.error("Unable to create directory for chat logs.");
        throw new RuntimeException("Unable to create directory for chat logs.");
    });
    private static final File UNSAVED_MARKER = new File(CHATLOG_FOLDER, "unsaved.marker");
    private static SimpleSessionRecorder current = null;
    private final String sessionName;
    private final File logFile;
    private final File lockFile;
    private final long startTime;
    private final long sessionId;
    private final BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Thread writerThread;
    private BufferedWriter writer;
    private FileLock fileLock;
    private RandomAccessFile lockRaf;

    private SimpleSessionRecorder(String sessionName, boolean isMultiplayer) {
        this.sessionName = sessionName;
        this.startTime = System.currentTimeMillis();
        String timestamp = LocalDateTime.now().format(FILE_TIMESTAMP_FORMAT);
        String fileName = String.format("%s_%s.txt", sessionName.replaceAll("[^a-zA-Z0-9]", "_"), timestamp);
        this.logFile = new File(CHATLOG_FOLDER, fileName);
        this.lockFile = new File(CHATLOG_FOLDER, fileName + ".lock");
        long tempSessionId = -1L;
        try {
            SessionDatabase db = SessionDatabase.getInstance();
            tempSessionId = db.createSession(sessionName, isMultiplayer, this.logFile.getAbsolutePath());
            ChatLogsMod.LOGGER.info("Created SQLite session: {} (ID: {})", (Object)sessionName, (Object)tempSessionId);
        }
        catch (Exception e) {
            ChatLogsMod.LOGGER.error("Failed to create SQLite session for: {}", (Object)sessionName, (Object)e);
            throw new RuntimeException("Critical error: Unable to create SQLite session", e);
        }
        this.sessionId = tempSessionId;
        if (this.initializeWriter()) {
            this.markUnsaved();
            this.writerThread = new Thread(this::writerLoop, "ChatLog Writer");
            this.writerThread.setDaemon(true);
            this.writerThread.start();
            this.queueSessionStart();
            ChatLogsMod.LOGGER.info("Started chat logging session: {}", (Object)fileName);
        } else {
            this.writerThread = null;
        }
    }

    private boolean initializeWriter() {
        try {
            this.lockRaf = new RandomAccessFile(this.lockFile, "rw");
            FileChannel channel = this.lockRaf.getChannel();
            this.fileLock = channel.tryLock();
            if (this.fileLock == null) {
                ChatLogsMod.LOGGER.error("Could not acquire lock for chat log file: {}", (Object)this.logFile.getName());
                this.lockRaf.close();
                return false;
            }
            this.writer = new BufferedWriter(new FileWriter(this.logFile, true));
            return true;
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.error("Failed to initialize writer for chat log file: {}", (Object)this.logFile.getName(), (Object)e);
            this.cleanup();
            return false;
        }
    }

    private void queueSessionStart() {
        String sessionStart = "=== Chat Log Session Started ===\nSession: " + this.sessionName + "\nStart Time: " + LocalDateTime.now().format(TIMESTAMP_FORMAT) + "\n=====================================\n\n";
        this.messageQueue.offer(sessionStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writerLoop() {
        while (true) lbl-1000:
        // 5 sources

        {
            if (!this.running.get()) {
                if (this.messageQueue.isEmpty() != false) return;
            }
            try {
                messageBatch = new ArrayList<String>();
                firstMessage = this.messageQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (firstMessage == null) ** GOTO lbl-1000
                messageBatch.add(firstMessage);
                this.messageQueue.drainTo(messageBatch, 99);
                for (String message : messageBatch) {
                    this.writer.write(message);
                }
                this.writer.flush();
                if (messageBatch.size() <= 1) ** GOTO lbl-1000
                ChatLogsMod.LOGGER.debug("Processed batch of {} messages", (Object)messageBatch.size());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (IOException e) {
                ChatLogsMod.LOGGER.error("Error writing to chat log", (Throwable)e);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            try {
                if (this.writer != null) {
                    sessionEnd = "\n=====================================\nSession ended: " + LocalDateTime.now().format(SimpleSessionRecorder.TIMESTAMP_FORMAT) + "\nDuration: " + this.formatDuration(System.currentTimeMillis() - this.startTime) + "\n=====================================\n";
                    this.writer.write(sessionEnd);
                }
            }
            catch (IOException e) {
                ChatLogsMod.LOGGER.error("Error writing session end", (Throwable)e);
            }
            this.cleanup();
            this.unmarkUnsaved();
            ChatLogsMod.LOGGER.info("Chat logging session ended: {}", (Object)this.logFile.getName());
        }
    }

    private void cleanup() {
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.error("Error closing writer", (Throwable)e);
        }
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.error("Error releasing file lock", (Throwable)e);
        }
        try {
            if (this.lockRaf != null) {
                this.lockRaf.close();
                this.lockRaf = null;
            }
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.error("Error closing lock file", (Throwable)e);
        }
        if (this.lockFile.exists()) {
            this.lockFile.delete();
        }
    }

    private void markUnsaved() {
        try (FileWriter fw = new FileWriter(UNSAVED_MARKER, true);){
            fw.append(this.logFile.getAbsolutePath()).append('\n');
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.warn("Unable to create unsaved marker", (Throwable)e);
        }
    }

    private void unmarkUnsaved() {
        if (!UNSAVED_MARKER.exists()) {
            return;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        String unsavedFilePath = this.logFile.getAbsolutePath();
        try (Scanner s = new Scanner(new FileReader(UNSAVED_MARKER));){
            while (s.hasNextLine()) {
                String line = s.nextLine().trim();
                if (line.equals(unsavedFilePath) || line.isEmpty()) continue;
                filtered.add(line);
            }
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.warn("Unable to read unsaved marker", (Throwable)e);
            return;
        }
        try (FileWriter fw = new FileWriter(UNSAVED_MARKER, false);){
            for (String line : filtered) {
                fw.write(line);
                fw.write(10);
            }
        }
        catch (IOException e) {
            ChatLogsMod.LOGGER.warn("Unable to update unsaved marker", (Throwable)e);
        }
    }

    public static SimpleSessionRecorder start(String sessionName, boolean isMultiplayer) {
        if (current != null) {
            current.end();
        }
        SimpleSessionRecorder.cleanupOrphanedLocks();
        current = new SimpleSessionRecorder(sessionName, isMultiplayer);
        return current;
    }

    private static void cleanupOrphanedLocks() {
        File[] lockFiles = CHATLOG_FOLDER.listFiles((dir, name) -> name.endsWith(".lock"));
        if (lockFiles != null) {
            for (File lockFile : lockFiles) {
                if (!lockFile.delete()) continue;
                ChatLogsMod.LOGGER.debug("Cleaned up orphaned lock file: {}", (Object)lockFile.getName());
            }
        }
    }

    public static SimpleSessionRecorder current() {
        return current;
    }

    public static void end() {
        if (current != null) {
            current.shutdown();
            current = null;
        }
    }

    public void logMessage(class_2561 message) {
        String messageText;
        if (!this.running.get() || this.writerThread == null) {
            return;
        }
        String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMAT);
        String formattedMessage = String.format("[%s] %s\n", timestamp, messageText = message.getString());
        if (!this.messageQueue.offer(formattedMessage)) {
            ChatLogsMod.LOGGER.warn("Chat log message queue is full, dropping message");
        }
        try {
            String senderName = ChatLogsConfig.getInstance().extractSenderName(this.sessionName, messageText);
            String messageJson = ((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)message).result().orElse(JsonNull.INSTANCE)).toString();
            SessionDatabase db = SessionDatabase.getInstance();
            db.addMessage(this.sessionId, senderName, messageText, messageJson);
        }
        catch (Exception e) {
            ChatLogsMod.LOGGER.error("Failed to save message to SQLite", (Throwable)e);
            throw new RuntimeException("Critical error: Unable to save message to SQLite", e);
        }
    }

    private void shutdown() {
        this.running.set(false);
        if (this.writerThread != null) {
            try {
                this.writerThread.join(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ChatLogsMod.LOGGER.warn("Interrupted while waiting for writer thread to finish");
            }
        }
        if (this.sessionId != -1L) {
            try {
                SessionDatabase db = SessionDatabase.getInstance();
                db.endSession(this.sessionId);
                ChatLogsMod.LOGGER.info("Ended SQLite session: {}", (Object)this.sessionId);
            }
            catch (Exception e) {
                ChatLogsMod.LOGGER.error("Failed to end SQLite session: {}", (Object)this.sessionId, (Object)e);
                throw new RuntimeException("Critical error: Unable to end SQLite session", e);
            }
        }
    }

    private String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes % 60L, seconds % 60L);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds % 60L);
        }
        return String.format("%ds", seconds);
    }
}

