/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.logic;

import eu.mc.sync.logic.events.player.PlayerJoinEvent;
import eu.mc.sync.logic.model.chat.ChatEvent;
import eu.mc.sync.logic.model.player.PlayerAdvancementDoneEvent;
import eu.mc.sync.logic.model.player.PlayerDeathEvent;
import eu.mc.sync.logic.model.player.PlayerQuitEvent;
import eu.mc.sync.logic.service.EventCoordinator;
import eu.mc.sync.logic.service.SchedulerService;
import eu.mc.sync.logic.services.interaction.InteractionService;
import eu.mc.sync.platform.PlatformAdapter;

public class McSyncCommon {
    private final PlatformAdapter platform;
    private final String platformName;
    private final InteractionService interactionService;
    private final SchedulerService schedulerService;
    private final EventCoordinator eventCoordinator;

    public McSyncCommon(PlatformAdapter platform, String platformName) {
        this.platform = platform;
        this.platformName = platformName;
        this.interactionService = new InteractionService(platform);
        this.schedulerService = new SchedulerService(platform);
        this.eventCoordinator = new EventCoordinator(platform, this.interactionService);
    }

    public void init() {
        this.logIfDevMode("Initializing McSync Common...");
        this.schedulerService.startMessageFetching(this::fetchMessagesFromDiscord);
        this.interactionService.checkUpdate(this.platformName);
        this.logIfDevMode("McSync Common initialized successfully!");
    }

    public void shutdown() {
        this.logIfDevMode("Shutting down McSync Common...");
        this.interactionService.shutdown();
        this.schedulerService.shutdown();
        this.logIfDevMode("McSync Common shut down successfully!");
    }

    private void fetchMessagesFromDiscord() {
        try {
            this.interactionService.fetchAndBroadcastMessages();
        }
        catch (Exception e) {
            this.platform.logSevere("Error while fetching messages from Discord: " + e.getMessage());
        }
    }

    public void onJoin(PlayerJoinEvent event) {
        this.eventCoordinator.handleJoin(event);
    }

    public void onQuit(PlayerQuitEvent event) {
        this.eventCoordinator.handleQuit(event);
    }

    public void onDeath(PlayerDeathEvent event) {
        this.eventCoordinator.handleDeath(event);
    }

    public void onChat(ChatEvent event) {
        this.eventCoordinator.handleChat(event);
    }

    public void onAdvancement(PlayerAdvancementDoneEvent event) {
        this.eventCoordinator.handleAdvancement(event);
    }

    private void logIfDevMode(String message) {
        if (this.platform.getDevMode()) {
            this.platform.logInfo(message);
        }
    }
}

