/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.logic.service;

import eu.mc.sync.logic.model.chat.ChatEvent;
import eu.mc.sync.logic.model.player.PlayerAdvancementDoneEvent;
import eu.mc.sync.logic.model.player.PlayerDeathEvent;
import eu.mc.sync.logic.model.player.PlayerJoinEvent;
import eu.mc.sync.logic.model.player.PlayerQuitEvent;
import eu.mc.sync.logic.services.interaction.InteractionService;
import eu.mc.sync.platform.PlatformAdapter;

public class EventCoordinator {
    private final PlatformAdapter platform;
    private final InteractionService interactionService;

    public EventCoordinator(PlatformAdapter platform, InteractionService interactionService) {
        this.platform = platform;
        this.interactionService = interactionService;
    }

    public void handleJoin(eu.mc.sync.logic.events.player.PlayerJoinEvent event) {
        this.logEventIfDevMode("Player " + event.getPlayerName() + " joined the game!");
        this.interactionService.handleJoin(new PlayerJoinEvent(event.getPlayerName()));
    }

    public void handleQuit(PlayerQuitEvent event) {
        this.logEventIfDevMode("Player " + event.playerName() + " left the game!");
        this.interactionService.handleQuit(event);
    }

    public void handleDeath(PlayerDeathEvent event) {
        this.logEventIfDevMode("Player " + event.playerName() + " died!");
        this.interactionService.handleDeath(event);
    }

    public void handleChat(ChatEvent event) {
        this.interactionService.handleChat(event);
    }

    public void handleAdvancement(PlayerAdvancementDoneEvent event) {
        this.interactionService.handleAdvancement(event);
    }

    private void logEventIfDevMode(String message) {
        if (this.platform.getDevMode()) {
            this.platform.logInfo(message);
        }
    }
}

