/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.logic.service;

import eu.mc.sync.platform.PlatformAdapter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SchedulerService {
    private final PlatformAdapter platform;
    private ScheduledExecutorService scheduler;

    public SchedulerService(PlatformAdapter platform) {
        this.platform = platform;
    }

    public void startMessageFetching(Runnable task) {
        if (this.platform.getDevMode()) {
            this.platform.logInfo("Starting message fetching scheduler...");
        }
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(task, 0L, 5L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        if (this.scheduler == null) {
            return;
        }
        if (this.platform.getDevMode()) {
            this.platform.logInfo("Shutting down scheduler...");
        }
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

