/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.logic.services.batch;

import eu.mc.sync.logic.model.rest.InteractionTO;
import eu.mc.sync.rest.DiscordApi;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BatchService {
    private final DiscordApi api;
    private final ConcurrentLinkedQueue<InteractionTO> messageQueue;
    private final ScheduledExecutorService batchScheduler;

    public BatchService(DiscordApi api) {
        this.api = api;
        this.messageQueue = new ConcurrentLinkedQueue();
        this.batchScheduler = Executors.newScheduledThreadPool(1);
        this.startBatchScheduler();
    }

    public void queueInteraction(InteractionTO interaction) {
        this.messageQueue.offer(interaction);
    }

    private void startBatchScheduler() {
        this.batchScheduler.scheduleAtFixedRate(this::sendBatchedMessages, 3L, 3L, TimeUnit.SECONDS);
    }

    private void sendBatchedMessages() {
        InteractionTO message;
        if (this.messageQueue.isEmpty()) {
            return;
        }
        ArrayList<InteractionTO> batch = new ArrayList<InteractionTO>();
        while ((message = this.messageQueue.poll()) != null) {
            batch.add(message);
        }
        if (!batch.isEmpty()) {
            this.api.sendInteractionBatch(batch);
        }
    }

    public void shutdown() {
        if (this.batchScheduler != null) {
            this.sendBatchedMessages();
            this.batchScheduler.shutdown();
            try {
                if (!this.batchScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.batchScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.batchScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

