/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.logic.services.interaction;

import eu.mc.sync.logic.model.chat.ChatEvent;
import eu.mc.sync.logic.model.player.PlayerAdvancementDoneEvent;
import eu.mc.sync.logic.model.player.PlayerDeathEvent;
import eu.mc.sync.logic.model.player.PlayerJoinEvent;
import eu.mc.sync.logic.model.player.PlayerQuitEvent;
import eu.mc.sync.logic.model.rest.InteractionTO;
import eu.mc.sync.logic.services.advancement.AdvancementKeyTranslationService;
import eu.mc.sync.logic.services.batch.BatchService;
import eu.mc.sync.logic.services.general.TimestampService;
import eu.mc.sync.platform.PlatformAdapter;
import eu.mc.sync.rest.DiscordApi;

public class InteractionService {
    private final DiscordApi api;
    private final BatchService batchService;

    public InteractionService(PlatformAdapter platform) {
        this.api = new DiscordApi(platform);
        this.batchService = new BatchService(this.api);
    }

    public void handleJoin(PlayerJoinEvent event) {
        InteractionTO interaction = new InteractionTO(event.playerName(), TimestampService.get(), "join", "joined the server");
        this.batchService.queueInteraction(interaction);
    }

    public void handleQuit(PlayerQuitEvent event) {
        InteractionTO interaction = new InteractionTO(event.playerName(), TimestampService.get(), "leave", "left the server");
        this.batchService.queueInteraction(interaction);
    }

    public void handleDeath(PlayerDeathEvent event) {
        InteractionTO interaction = new InteractionTO(event.playerName(), TimestampService.get(), "death", event.deathMessage());
        this.batchService.queueInteraction(interaction);
    }

    public void handleChat(ChatEvent event) {
        InteractionTO interaction = new InteractionTO(event.playerName(), TimestampService.get(), "message", event.message());
        this.batchService.queueInteraction(interaction);
    }

    public void handleAdvancement(PlayerAdvancementDoneEvent event) {
        String translatableKey = AdvancementKeyTranslationService.translateToTranslatableKey(event.advancementKey());
        InteractionTO interaction = new InteractionTO(event.playerName(), TimestampService.get(), "advancement", translatableKey);
        this.batchService.queueInteraction(interaction);
    }

    public void fetchAndBroadcastMessages() {
        this.api.broadcastMessagesFromDiscord();
    }

    public void checkUpdate(String platformName) {
        this.api.isNewVersionAvailable(platformName);
    }

    public void shutdown() {
        this.batchService.shutdown();
    }
}

