/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.paper;

import eu.mc.sync.logic.McSyncCommon;
import eu.mc.sync.logic.model.chat.ChatEvent;
import eu.mc.sync.logic.model.player.PlayerDeathEvent;
import io.papermc.paper.advancement.AdvancementDisplay;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PaperEventListener
implements Listener {
    private final McSyncCommon common;

    public PaperEventListener(McSyncCommon common) {
        this.common = common;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.common.onJoin(new eu.mc.sync.logic.events.player.PlayerJoinEvent(event.getPlayer().getName()));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.common.onQuit(new eu.mc.sync.logic.model.player.PlayerQuitEvent(event.getPlayer().getName()));
    }

    @EventHandler
    public void onDeath(org.bukkit.event.entity.PlayerDeathEvent event) {
        String msg = PlainTextComponentSerializer.plainText().serialize(Objects.requireNonNull(event.deathMessage()));
        this.common.onDeath(new PlayerDeathEvent(event.getEntity().getName(), msg));
    }

    @EventHandler
    public void onChat(AsyncChatEvent event) {
        String msg = PlainTextComponentSerializer.plainText().serialize(event.message());
        this.common.onChat(new ChatEvent(event.getPlayer().getName(), msg));
    }

    @EventHandler
    public void onAdvancement(PlayerAdvancementDoneEvent event) {
        AdvancementDisplay display = event.getAdvancement().getDisplay();
        if (display != null) {
            String string;
            Component title = display.title();
            if (title instanceof TranslatableComponent) {
                TranslatableComponent t = (TranslatableComponent)title;
                string = t.key();
            } else {
                string = title.toString();
            }
            String key = string;
            this.common.onAdvancement(new eu.mc.sync.logic.model.player.PlayerAdvancementDoneEvent(event.getPlayer().getName(), key));
        }
    }
}

