/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.rest;

import com.google.gson.Gson;
import eu.mc.sync.logic.model.rest.InteractionTO;
import eu.mc.sync.platform.PlatformAdapter;
import eu.mc.sync.rest.service.HttpConnectionService;
import eu.mc.sync.rest.service.InteractionBatchService;
import eu.mc.sync.rest.service.MessageService;
import eu.mc.sync.rest.service.VersionService;
import eu.mc.sync.rest.util.JsonUtils;
import java.util.List;

public class DiscordApi {
    private final InteractionBatchService interactionBatchService;
    private final MessageService messageService;
    private final VersionService versionService;

    public DiscordApi(PlatformAdapter platform) {
        Gson gson = JsonUtils.createGson();
        HttpConnectionService connectionService = new HttpConnectionService(platform);
        this.interactionBatchService = new InteractionBatchService(platform, gson, connectionService);
        this.messageService = new MessageService(platform, gson, connectionService);
        this.versionService = new VersionService(platform, gson, connectionService);
    }

    public void sendInteractionBatch(List<InteractionTO> interactions) {
        this.interactionBatchService.sendInteractionBatch(interactions);
    }

    public void broadcastMessagesFromDiscord() {
        this.messageService.broadcastMessagesFromDiscord();
    }

    public void isNewVersionAvailable(String platformName) {
        this.versionService.checkForUpdates(platformName);
    }
}

