/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.rest.service;

import com.google.gson.Gson;
import eu.mc.sync.logic.model.rest.InteractionTO;
import eu.mc.sync.platform.PlatformAdapter;
import eu.mc.sync.rest.service.ApiErrorState;
import eu.mc.sync.rest.service.HttpConnectionService;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class InteractionBatchService {
    private static final String API_BATCH_URL = "https://api.mc-sync.eu/v1/messages";
    private final PlatformAdapter platform;
    private final Gson gson;
    private final HttpConnectionService connectionService;

    public InteractionBatchService(PlatformAdapter platform, Gson gson, HttpConnectionService connectionService) {
        this.platform = platform;
        this.gson = gson;
        this.connectionService = connectionService;
    }

    public void sendInteractionBatch(List<InteractionTO> interactions) {
        if (interactions == null || interactions.isEmpty()) {
            return;
        }
        if (ApiErrorState.hasAuthenticationFailed()) {
            return;
        }
        if (!this.isApiTokenValid()) {
            return;
        }
        try {
            URL url = new URI(API_BATCH_URL).toURL();
            HttpURLConnection connection = this.connectionService.createPostConnection(url);
            this.sendInteractionData(connection, interactions);
            this.handleResponse(connection, interactions.size());
        }
        catch (Exception e) {
            this.platform.logSevere("Error while sending interactions to Discord: " + e.getMessage());
        }
    }

    private boolean isApiTokenValid() {
        String apiToken = this.platform.getApiToken();
        if (apiToken == null || apiToken.trim().isEmpty() || "YOUR_API_TOKEN".equals(apiToken)) {
            this.platform.logSevere("Cannot send interactions to Discord: API token is not configured. Please set a valid API token in the configuration file.");
            return false;
        }
        return true;
    }

    private void sendInteractionData(HttpURLConnection connection, List<InteractionTO> interactions) throws Exception {
        String jsonPayload = this.gson.toJson(interactions);
        if (this.platform.getDevMode()) {
            this.platform.logInfo("Sending batch POST request to: https://api.mc-sync.eu/v1/messages");
            this.platform.logInfo("Batch size: " + interactions.size() + " interactions");
            this.platform.logInfo("JSON payload: " + jsonPayload);
        }
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
    }

    private void handleResponse(HttpURLConnection connection, int batchSize) throws Exception {
        int responseCode = connection.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            if (this.platform.getDevMode()) {
                this.platform.logInfo("Successfully sent " + batchSize + " interactions to Discord");
            }
        } else if (responseCode == 401) {
            ApiErrorState.markAuthenticationFailed();
            this.platform.logSevere("Please set the token in the server config and restart the server.");
        } else if (responseCode == 403) {
            this.platform.logSevere("Error while sending interactions to Discord: Access forbidden (403 Forbidden)");
        } else {
            this.platform.logSevere("Error while sending interactions to Discord: HTTP " + responseCode);
        }
    }
}

